<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>New Enrollment Notification</title>
</head>
<body style="font-family: 'Inter', Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; background: #f4f4f4;">
    <div style="max-width: 700px; margin: 30px auto; background: #ffffff; border-radius: 15px; overflow: hidden; box-shadow: 0 8px 30px rgba(0,0,0,0.08); position: relative;">
        
      

        {{-- Header --}}
        <div style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); color: white; padding: 40px 25px; text-align: center; position: relative; z-index: 1;">
            
            {{-- Centered main logo --}}
            @if($setting->logo)
            <div style="margin-bottom: 15px;">
                <img src="cid:logo.png" alt="Logo" 
                     style="width: 150px; height: auto; background: white; border-radius: 10px; padding: 5px; display: inline-block;">
            </div>
            @endif

            <h1 style="font-size: 1.6rem; margin: 10px 0 5px;">📚 New Course Enrollment</h1>
            <p style="margin: 0; font-size: 1rem;">A new student has enrolled in one of your courses</p>
            <div style="margin-top: 15px; background: rgba(255,255,255,0.2); padding: 10px 25px; border-radius: 30px; font-weight: 600; display: inline-block;">
                Action Required: Review Enrollment
            </div>
        </div>

        {{-- Body --}}
        <div style="padding: 40px; position: relative; z-index: 2;">
            
            {{-- Notification Box --}}
            <div style="background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 10px; padding: 20px; margin-bottom: 25px;">
                <strong style="font-size: 1.1rem;">🚨 New Enrollment Alert!</strong>
                <p style="margin: 10px 0 0;">Please review the student and course details below.</p>
            </div>

            {{-- Enrollment Code --}}
            <div style="background: #007bff; color: white; padding: 15px; border-radius: 8px; text-align: center; margin: 25px 0; font-size: 1.1rem; font-weight: 600;">
                Enrollment Code: {{ $enrollment->enrollment_code }}
            </div>

            {{-- Student + Course Info --}}
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                
                {{-- Student Info --}}
                <div style="background: #f8f9fa; border-radius: 10px; padding: 20px;">
                    <h3 style="margin-top: 0; color: #495057; font-size: 1.2rem;">Student Information</h3>
                    <p><strong>Full Name:</strong> {{ $enrollment->first_name }} {{ $enrollment->last_name }}</p>
                    <p><strong>Email:</strong> {{ $enrollment->email }}</p>
                    <p><strong>Phone:</strong> {{ $enrollment->phone }}</p>
                    <p><strong>Education Level:</strong> {{ $enrollment->education_level ?: 'Not specified' }}</p>
                    <p><strong>Experience Level:</strong> {{ $enrollment->experience_level ?: 'Not specified' }}</p>
                </div>

                {{-- Course Info --}}
                <div style="background: #f8f9fa; border-radius: 10px; padding: 20px;">
                    <h3 style="margin-top: 0; color: #495057; font-size: 1.2rem;">Course Information</h3>
                    <p><strong>Course Title:</strong> {{ $enrollment->course->title }}</p>
                    <p><strong>Level:</strong> {{ ucfirst($enrollment->course->level) }}</p>
                    <p><strong>Duration:</strong> {{ $enrollment->course->duration_value }} {{ $enrollment->course->duration_type }}</p>
                    <p><strong>Price Type:</strong> {{ ucfirst($enrollment->course->price_type) }}</p>
                    <p><strong>Schedule:</strong> {{ ucfirst($enrollment->preferred_schedule) }}</p>
                </div>
            </div>

            {{-- Motivation --}}
            @if($enrollment->motivation)
            <div style="margin-top: 25px; background: #f8f9fa; border-radius: 10px; padding: 20px;">
                <h3 style="margin-top: 0; color: #495057; font-size: 1.2rem;">Student Motivation</h3>
                <div style="background: white; padding: 15px; border-radius: 8px; border-left: 4px solid #007bff;">
                    {{ $enrollment->motivation }}
                </div>
            </div>
            @endif

            {{-- CTA Button --}}
            <div style="text-align: center; margin-top: 30px;">
                <a href="{{ url('/admin/enrollments') }}" 
                   style="display: inline-block; background: #28a745; color: white; padding: 12px 35px; text-decoration: none; border-radius: 8px; font-weight: 600;">
                    📊 View in Admin Panel
                </a>
            </div>

            {{-- Meta Info --}}
            <div style="margin-top: 30px; padding: 15px; background: #e9ecef; border-radius: 8px; text-align: center; font-size: 0.9rem;">
                <strong>Enrollment Time:</strong> {{ $enrollment->created_at->format('F d, Y \a\t h:i A') }}<br>
                <strong>Newsletter:</strong> {{ $enrollment->newsletter_optin ? 'Subscribed' : 'Not Subscribed' }}
            </div>
        </div>

        {{-- Footer --}}
        <div style="background: #343a40; color: white; padding: 25px; text-align: center; font-size: 0.9rem;">
            <p style="margin: 0 0 8px;">This is an automated notification from Quran Academy Enrollment System</p>
            <p style="margin: 0;">&copy; {{ date('Y') }} {{ $setting->site_name }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
