@extends('apps')

@section('content')
<main class="main">
    <!-- Page Title -->
    <div class="page-title light-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0">Enrollment</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="{{ url('/') }}">Home</a></li>
                    <li class="current">Enroll</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Enroll Section -->
    <section id="enroll" class="enroll section">
        <div class="container" data-aos="fade-up" data-aos-delay="100">
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="enrollment-form-wrapper">
                        <div class="enrollment-header text-center mb-5" data-aos="fade-up" data-aos-delay="200">
                            <h2>Enroll in {{ $course->title }}</h2>
                            <p>Take the next step in your educational journey. Complete the form below to secure your spot in our comprehensive online learning program.</p>
                        </div>

                        <form id="enrollmentForm" action="{{ route('enrollment.process', $course->id) }}" class="enrollment-form" data-aos="fade-up" data-aos-delay="300">
                            @csrf
                            
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="firstName" class="form-label">First Name *</label>
                                        <input type="text" id="firstName" name="first_name" class="form-control" required autocomplete="given-name" placeholder="Enter Your Name">
                                        <div class="invalid-feedback">Please provide your first name.</div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="lastName" class="form-label">Last Name *</label>
                                        <input type="text" id="lastName" name="last_name" class="form-control" required autocomplete="family-name"  placeholder="Enter Your Last Name">
                                        <div class="invalid-feedback">Please provide your last name.</div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="email" class="form-label">Email Address *</label>
                                        <input type="email" id="email" name="email" class="form-control" required autocomplete="email" placeholder="Enter Your Email">
                                        <div class="invalid-feedback">Please provide a valid email address.</div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="phone" class="form-label">Phone Number *</label>
                                        <input type="tel" id="phone" name="phone" class="form-control" required autocomplete="tel" placeholder="Enter Your Phone Number">
                                        <div class="invalid-feedback">Please provide your phone number.</div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label">Selected Course</label>
                                        <div class="selected-course alert alert-info">
                                            <strong>{{ $course->title }}</strong><br>
                                            <small>Level: {{ ucfirst($course->level) }} | Duration: {{ $course->duration_value }} {{ $course->duration_type }} | Price: {{ $course->price_type === 'free' ? 'Free' : '$' . $course->price }}</small>
                                        </div>
                                        <input type="hidden" name="course_id" value="{{ $course->id }}">
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="education" class="form-label">Education Level</label>
                                        <select id="education" name="education_level" class="form-select">
                                            <option value="">Select your education level...</option>
                                            <option value="high-school">High School</option>
                                            <option value="associate">Associate Degree</option>
                                            <option value="bachelor">Bachelor's Degree</option>
                                            <option value="master">Master's Degree</option>
                                            <option value="doctorate">Doctorate</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="experience" class="form-label">Experience Level</label>
                                        <select id="experience" name="experience_level" class="form-select">
                                            <option value="">Select your experience...</option>
                                            <option value="beginner">Beginner</option>
                                            <option value="intermediate">Intermediate</option>
                                            <option value="advanced">Advanced</option>
                                            <option value="expert">Expert</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="motivation" class="form-label">What motivates you to take this course?</label>
                                        <textarea id="motivation" name="motivation" class="form-control" rows="4" placeholder="Share your goals and what you hope to achieve..."></textarea>
                                    </div>
                                </div>
                            </div>

                            




          <div class="row mb-4">
                  <div class="col-12">
                    <div class="form-group">
                      <label class="form-label">Preferred Learning Schedule</label>
                      <div class="schedule-options">
                        <div class="form-check">
                      <input class="form-check-input" type="radio" name="preferred_schedule" id="weekdays" value="weekdays" required>
                          <label class="form-check-label" for="weekdays">
                            Weekdays (Monday - Friday)
                          </label>
                        </div>
                        <div class="form-check">
                       <input class="form-check-input" type="radio" name="preferred_schedule" id="weekends" value="weekends" required>
                          <label class="form-check-label" for="weekends">
                            Weekends (Saturday - Sunday)
                          </label>
                        </div>
                        <div class="form-check">
                   

 <input class="form-check-input" type="radio" name="preferred_schedule" id="flexible" value="flexible" required checked>


                          <label class="form-check-label" for="flexible">
                            Flexible (Self-paced)
                          </label>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>




                            <div class="row mb-4">
                                <div class="col-12">
                                    <div class="form-group">
                                        <div class="agreement-section">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="terms" name="terms" required>
                                                <label class="form-check-label" for="terms">
                                                    I agree to the <a href="#">Terms of Service</a> and <a href="#">Privacy Policy</a> *
                                                </label>
                                                <div class="invalid-feedback">You must agree to the terms and conditions.</div>
                                            </div>
                                            <div class="form-check mt-2">
                                                <input class="form-check-input" type="checkbox" id="newsletter" name="newsletter">
                                                <label class="form-check-label" for="newsletter">
                                                    I would like to receive course updates and educational content via email
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-enroll">
                                        <i class="bi bi-check-circle me-2"></i>
                                        Enroll Now
                                    </button>
                                    <p class="enrollment-note mt-3">
                                        <i class="bi bi-shield-check"></i>
                                        Your information is secure and will never be shared with third parties
                                    </p>
                                </div>
                            </div>
                        </form>
                    </div>
                </div><!-- End Form Column -->

                <div class="col-lg-4 d-none d-lg-block">
                    <div class="enrollment-benefits" data-aos="fade-left" data-aos-delay="400">
                        <h3>Why Choose Our Courses?</h3>
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="bi bi-trophy"></i>
                            </div>
                            <div class="benefit-content">
                                <h4>Expert Instructors</h4>
                                <p>Learn from industry professionals with years of real-world experience</p>
                            </div>
                        </div><!-- End Benefit Item -->

                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="bi bi-clock"></i>
                            </div>
                            <div class="benefit-content">
                                <h4>Flexible Learning</h4>
                                <p>Study at your own pace with 24/7 access to course materials</p>
                            </div>
                        </div><!-- End Benefit Item -->

                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="bi bi-award"></i>
                            </div>
                            <div class="benefit-content">
                                <h4>Certification</h4>
                                <p>Earn industry-recognized certificates upon course completion</p>
                            </div>
                        </div><!-- End Benefit Item -->

                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="bi bi-people"></i>
                            </div>
                            <div class="benefit-content">
                                <h4>Community Support</h4>
                                <p>Connect with fellow students and get help when you need it</p>
                            </div>
                        </div><!-- End Benefit Item -->

                        <div class="enrollment-stats mt-4">
                            <div class="stat-item">
                                <span class="stat-number">{{ $course->total_students }}+</span>
                                <span class="stat-label">Students Enrolled</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-number">{{ number_format($course->ratings, 1) }}/5</span>
                                <span class="stat-label">Average Rating</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-number">{{ $course->has_certificate ? 'Yes' : 'No' }}</span>
                                <span class="stat-label">Certificate</span>
                            </div>
                        </div><!-- End Stats -->
                    </div>
                </div><!-- End Benefits Column -->
            </div>
        </div>
    </section><!-- /Enroll Section -->
</main>

@include('footer')

<style>
.enrollment-form-wrapper {
    background: #fff;
    padding: 40px;
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.selected-course {
    border-left: 4px solid #007bff;
}

.schedule-options {
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
}

.card-option {
    margin: 0;
}

.card-option-label {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
    padding: 20px;
    border: 2px solid #e9ecef;
    border-radius: 10px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.card-option-label:hover {
    border-color: #667eea;
    background: #f0f4ff;
}

.form-check-input:checked + .card-option-label {
    border-color: #667eea;
    background: #f0f4ff;
}

.card-option-label strong {
    margin: 10px 0 5px;
    color: #495057;
}

.card-option-label span {
    color: #6c757d;
    font-size: 0.9rem;
}

.btn-enroll {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    color: white;
    padding: 15px 40px;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-enroll:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
}

.enrollment-note {
    color: #6c757d;
    font-size: 0.9rem;
}

.enrollment-benefits {
    background: #f8f9fa;
    padding: 30px;
    border-radius: 15px;
    height: fit-content;
}

.benefit-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 25px;
}

.benefit-icon {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    margin-right: 15px;
    flex-shrink: 0;
}

.benefit-content h4 {
    margin: 0 0 5px 0;
    color: #495057;
}

.benefit-content p {
    margin: 0;
    color: #6c757d;
    font-size: 0.9rem;
}

.enrollment-stats {
    grid-template-columns: repeat(3, 1fr);
    gap: 15px;
    text-align: center;
}

.stat-item {
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.stat-number {
    display: block;
    font-size: 1.5rem;
    font-weight: 700;
    color: #667eea;
}

.stat-label {
    font-size: 0.8rem;
    color: #6c757d;
}

.invalid-feedback {
    display: none;
    width: 100%;
    margin-top: 0.25rem;
    font-size: 0.875rem;
    color: #dc3545;
}

.was-validated .form-control:invalid ~ .invalid-feedback,
.was-validated .form-check-input:invalid ~ .invalid-feedback {
    display: block;
}

.was-validated .form-control:invalid {
    border-color: #dc3545;
}

.was-validated .form-check-input:invalid {
    border-color: #dc3545;
}
</style>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.getElementById('enrollmentForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    
    submitBtn.innerHTML = 'Processing...';
    submitBtn.disabled = true;
    
    const formData = new FormData(this);
    
    fetch(this.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
.then(data => {
    if (data.success) {
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: data.message,
            confirmButtonText: 'OK'
        }).then(() => {
            // Page redirect mat karo, sirf form reset kar do
            document.getElementById('enrollForm').reset();

            // Optional: success section show karwa do
            const successBox = document.getElementById('successBox');
            if (successBox) {
                successBox.style.display = 'block';
                successBox.innerText = data.message;
            }
        });
    }
})

    .catch(error => {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Something went wrong!'
        });
    })
    .finally(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
});
</script>
@endsection
