<footer id="footer" class="ayz-footer">
    <div class="container">
        <div class="ayz-footer-main">
            <div class="row g-4">
                <!-- Company Info -->
                <div class="col-lg-4 col-md-6">
                    <div class="ayz-footer-about">
                        <a href="{{ url('/') }}" class="ayz-footer-logo">
                            @if($settings->logo)
<!--                             <img src="{{ asset($settings->logo) }}" alt="{{ $settings->site_name }}" class="ayz-logo-img">
 -->                            @endif
                            <span class="ayz-logo-text">{{ $settings->site_name }}</span>
                        </a>
                        <p class="ayz-footer-desc">{{ $settings->footer_content }}</p>
                        
                        <div class="ayz-social-links">
                            @if($settings->facebook_url)
                            <a href="{{ $settings->facebook_url }}" class="ayz-social-link">
                                <i class="bi bi-facebook"></i>
                            </a>
                            @endif
                            @if($settings->instagram_url)
                            <a href="{{ $settings->instagram_url }}" class="ayz-social-link">
                                <i class="bi bi-instagram"></i>
                            </a>
                            @endif
                            @if($settings->linkedin_url)
                            <a href="{{ $settings->linkedin_url }}" class="ayz-social-link">
                                <i class="bi bi-linkedin"></i>
                            </a>
                            @endif
                            @if($settings->tiktok_url)
                            <a href="{{ $settings->tiktok_url }}" class="ayz-social-link">
                                <i class="bi bi-tiktok"></i>
                            </a>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="col-lg-2 col-md-6">
                    <div class="ayz-footer-links">
                        <h5 class="ayz-footer-title">Quick Links</h5>
                        <ul class="ayz-links-list">
                            <li><a href="{{ url('/') }}" class="ayz-footer-link">Home</a></li>
                            <li><a href="{{ route('about') }}" class="ayz-footer-link">About</a></li>
                            <li><a href="{{ route('courses-quran') }}" class="ayz-footer-link">Courses</a></li>
                            <li><a href="{{ route('teacher') }}" class="ayz-footer-link">Instructors</a></li>
                            <li><a href="{{ route('blogs') }}" class="ayz-footer-link">Blog</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Courses -->
                <div class="col-lg-3 col-md-6">
                    <div class="ayz-footer-links">
                        <h5 class="ayz-footer-title">Our Courses</h5>
                        <ul class="ayz-links-list">
                            <li><a href="{{ route('courses-quran') }}" class="ayz-footer-link">Quran Learning</a></li>
                            <li><a href="#" class="ayz-footer-link">Arabic Language</a></li>
                            <li><a href="#" class="ayz-footer-link">Islamic Studies</a></li>
                            <li><a href="#" class="ayz-footer-link">Tajweed Rules</a></li>
                            <li><a href="#" class="ayz-footer-link">Memorization</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Contact -->
                <div class="col-lg-3 col-md-6">
                    <div class="ayz-footer-contact">
                        <h5 class="ayz-footer-title">Contact Us</h5>
                        
                        <div class="ayz-contact-item">
                            <i class="bi bi-geo-alt ayz-contact-icon"></i>
                            <span class="ayz-contact-text">{{ $settings->site_address }}</span>
                        </div>
                        
                        <div class="ayz-contact-item">
                            <i class="bi bi-telephone ayz-contact-icon"></i>
                            <a href="tel:{{ $settings->site_phone }}" class="ayz-contact-link">{{ $settings->site_phone }}</a>
                        </div>
                        
                        <div class="ayz-contact-item">
                            <i class="bi bi-envelope ayz-contact-icon"></i>
                            <a href="mailto:{{ $settings->site_email }}" class="ayz-contact-link">{{ $settings->site_email }}</a>
                        </div>

                        <!-- Newsletter -->
                        <div class="ayz-newsletter">
                            <h6 class="ayz-newsletter-title">Newsletter</h6>
                            <div class="ayz-newsletter-form">
                                <input type="email" class="ayz-newsletter-input" placeholder="Your email">
                                <button class="ayz-newsletter-btn">
                                    <i class="bi bi-send"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Divider -->
        <div class="ayz-footer-divider"></div>

        <!-- Bottom -->
        <div class="ayz-footer-bottom">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="ayz-copyright">
                        &copy; {{ date('Y') }} {{ $settings->footer_short_text }}. All rights reserved.
                    </p>
                </div>
                <div class="col-md-6">
                    <div class="ayz-legal-links">
                        <a href="terms.html" class="ayz-legal-link">Terms</a>
                        <a href="privacy.html" class="ayz-legal-link">Privacy</a>
                        <a href="{{ route('contact') }}" class="ayz-legal-link">Contact</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Back to Top -->
    <a href="#" class="ayz-back-top">
        <i class="bi bi-arrow-up"></i>
    </a>
</footer>

<style>
/* Footer Base */
.ayz-footer {
    background: #1a1a1a;
    color: #ffffff;
    position: relative;
    overflow: hidden;
}

.ayz-footer::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 1px;
    background: linear-gradient(90deg, transparent, #28c57a, transparent);
}

/* Main Footer */
.ayz-footer-main {
    padding: 60px 0 40px;
}

/* Footer About */
.ayz-footer-about {
    padding-right: 20px;
}

.ayz-footer-logo {
    display: flex;
    align-items: center;
    text-decoration: none;
    margin-bottom: 20px;
}

.ayz-logo-img {
    height: 40px;
    margin-right: 12px;
}

.ayz-logo-text {
    font-size: 1.5rem;
    font-weight: 700;
    color: #28c57a;
}

.ayz-footer-desc {
    color: #cccccc;
    line-height: 1.6;
    margin-bottom: 25px;
}

/* Social Links */
.ayz-social-links {
    display: flex;
    gap: 12px;
}

.ayz-social-link {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background: #333333;
    border-radius: 50%;
    color: #ffffff;
    text-decoration: none;
    transition: all 0.3s ease;
    border: 1px solid #444444;
}

.ayz-social-link:hover {
    background: #28c57a;
    color: white;
}

/* Footer Links */
.ayz-footer-links {
    margin-bottom: 30px;
}

.ayz-footer-title {
    color: #ffffff;
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 20px;
    position: relative;
    padding-bottom: 10px;
}

.ayz-footer-title::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 30px;
    height: 2px;
    background: #28c57a;
}

.ayz-links-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.ayz-links-list li {
    margin-bottom: 8px;
}

.ayz-footer-link {
    color: #cccccc;
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
    padding-left: 0;
}

.ayz-footer-link:hover {
    color: #28c57a;
    padding-left: 8px;
}

.ayz-footer-link::before {
    content: '›';
    position: absolute;
    left: -12px;
    opacity: 0;
    transition: all 0.3s ease;
}

.ayz-footer-link:hover::before {
    opacity: 1;
    left: -8px;
}

/* Footer Contact */
.ayz-footer-contact {
    margin-bottom: 30px;
}

.ayz-contact-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 15px;
}

.ayz-contact-icon {
    color: #28c57a;
    margin-right: 12px;
    margin-top: 2px;
    font-size: 1.1rem;
}

.ayz-contact-text {
    color: #cccccc;
    line-height: 1.5;
}

.ayz-contact-link {
    color: #cccccc;
    text-decoration: none;
    transition: color 0.3s ease;
}

.ayz-contact-link:hover {
    color: #28c57a;
}

/* Newsletter */
.ayz-newsletter {
    margin-top: 25px;
}

.ayz-newsletter-title {
    color: #ffffff;
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 12px;
}

.ayz-newsletter-form {
    display: flex;
    background: #333333;
    border-radius: 8px;
    overflow: hidden;
    border: 1px solid #444444;
}

.ayz-newsletter-input {
    flex: 1;
    padding: 12px 15px;
    background: transparent;
    border: none;
    color: #ffffff;
    outline: none;
}

.ayz-newsletter-input::placeholder {
    color: #888888;
}

.ayz-newsletter-btn {
    padding: 12px 15px;
    background: #28c57a;
    border: none;
    color: #ffffff;
    cursor: pointer;
    transition: background 0.3s ease;
}

.ayz-newsletter-btn:hover {
    background: #28c57a;
}

/* Footer Divider */
.ayz-footer-divider {
    height: 1px;
    background: #333333;
    margin: 20px 0;
}

/* Footer Bottom */
.ayz-footer-bottom {
    padding: 25px 0;
}

.ayz-copyright {
    color: #888888;
    margin: 0;
    font-size: 0.9rem;
}

.ayz-legal-links {
    display: flex;
    justify-content: flex-end;
    gap: 20px;
}

.ayz-legal-link {
    color: #888888;
    text-decoration: none;
    font-size: 0.9rem;
    transition: color 0.3s ease;
}

.ayz-legal-link:hover {
    color: #28c57a;
}

/* Back to Top */
.ayz-back-top {
    position: fixed;
    bottom: 30px;
    right: 30px;
    width: 50px;
    height: 50px;
    background: #28c57a;
    color: #ffffff;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
    z-index: 1000;
    border: none;
}

.ayz-back-top.ayz-show {
    opacity: 1;
    visibility: visible;
}

.ayz-back-top:hover {
    background: #28c57a;
    color: #ffffff;
}

/* Responsive */
@media (max-width: 768px) {
    .ayz-footer-main {
        padding: 40px 0 20px;
        text-align: center;
    }
    
    .ayz-footer-about {
        padding-right: 0;
        margin-bottom: 30px;
    }
    
    .ayz-footer-logo {
        justify-content: center;
    }
    
    .ayz-social-links {
        justify-content: center;
    }
    
    .ayz-footer-title::after {
        left: 50%;
        transform: translateX(-50%);
    }
    
    .ayz-contact-item {
        justify-content: center;
    }
    
    .ayz-legal-links {
        justify-content: center;
        margin-top: 15px;
    }
    
    .ayz-back-top {
        bottom: 20px;
        right: 20px;
        width: 45px;
        height: 45px;
    }
}

@media (max-width: 576px) {
    .ayz-legal-links {
        flex-direction: column;
        gap: 10px;
    }
    
    .ayz-footer-bottom .row > div {
        text-align: center;
    }
}
</style>

<script>
// Back to Top
const ayzBackTop = document.querySelector('.ayz-back-top');

window.addEventListener('scroll', function() {
    if (window.pageYOffset > 300) {
        ayzBackTop.classList.add('ayz-show');
    } else {
        ayzBackTop.classList.remove('ayz-show');
    }
});

ayzBackTop.addEventListener('click', function(e) {
    e.preventDefault();
    window.scrollTo({
        top: 0,
        behavior: 'smooth'
    });
});

// Newsletter Form
const ayzNewsletterForm = document.querySelector('.ayz-newsletter-form');
if (ayzNewsletterForm) {
    ayzNewsletterForm.addEventListener('submit', function(e) {
        e.preventDefault();
        const input = this.querySelector('.ayz-newsletter-input');
        const email = input.value.trim();
        
        if (email) {
            // Add your newsletter submission logic here
            alert('Thank you for subscribing to our newsletter!');
            input.value = '';
        }
    });
}

// Add click event to newsletter button
const ayzNewsletterBtn = document.querySelector('.ayz-newsletter-btn');
if (ayzNewsletterBtn) {
    ayzNewsletterBtn.addEventListener('click', function() {
        const form = this.closest('.ayz-newsletter-form');
        const input = form.querySelector('.ayz-newsletter-input');
        const email = input.value.trim();
        
        if (email) {
            alert('Thank you for subscribing to our newsletter!');
            input.value = '';
        }
    });
}
</script>