@extends('apps')

@section('content')
<style>
    :root {
        --primary: #1e40af;
        --primary-dark: #1e3a8a;
        --success: #059669;
        --warning: #d97706;
        --gray-100: #f3f4f6;
        --gray-800: #1f2937;
    }

    .course-header {
        background: linear-gradient(135deg, var(--gray-800) 0%, #374151 100%);
        color: white;
        padding: 60px 0 40px;
        border-bottom: 1px solid #e5e7eb;
    }

    .enroll-section {
        background: white;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        position: sticky;
        top: 100px;
    }

    .enroll-btn {
        background: var(--primary);
        border: none;
        padding: 16px 24px;
        font-size: 16px;
        font-weight: 600;
        border-radius: 6px;
        transition: all 0.2s ease;
        width: 100%;
    }

    .enroll-btn:hover {
        background: var(--primary-dark);
        transform: translateY(-1px);
    }

    .learning-item {
        padding: 12px 0;
        border-bottom: 1px solid #e5e7eb;
        display: flex;
        align-items: flex-start;
    }

    .learning-item:last-child {
        border-bottom: none;
    }

    .instructor-card {
        background: white;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 24px;
    }

    .feature-badge {
        background: var(--gray-100);
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        padding: 8px 12px;
        font-size: 14px;
        font-weight: 500;
    }

    .section-card {
        background: white;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 32px;
        margin-bottom: 24px;
    }

    .price-display {
        font-size: 32px;
        font-weight: 700;
        color: var(--gray-800);
    }

    .stat-number {
        font-size: 20px;
        font-weight: 700;
        color: var(--gray-800);
    }

    .stat-label {
        font-size: 14px;
        color: #6b7280;
    }
</style>

<!-- Professional Header -->
<div class="course-header">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <nav class="mb-4">
                    <span class="text-gray-300 text-sm">
                        <a href="/" class="text-gray-300 hover:text-white text-decoration-none">Home</a> 
                        <span class="mx-2">/</span>
                        <a href="{{ route('courses-quran') }}" class="text-gray-300 hover:text-white text-decoration-none">Courses</a>
                        <span class="mx-2">/</span>
                        <span class="text-white">{{ Str::limit($course->title, 40) }}</span>
                    </span>
                </nav>

                <h1 class="h2 fw-bold mb-3">{{ $course->title }}</h1>
                <p class="lead mb-4 text-gray-300">{{ Str::limit($course->description, 160) }}</p>

                <div class="d-flex flex-wrap gap-2 mb-4">
                    <span class="feature-badge text-dark">
                        <i class="fas fa-star text-warning me-1"></i>
                        {{ number_format($course->ratings, 1) }} rating
                    </span>
                    <span class="feature-badge text-dark">
                        <i class="fas fa-users text-primary me-1"></i>
                        {{ $course->total_students }} students
                    </span>
                    <span class="feature-badge text-dark">
                        <i class="fas fa-clock text-info me-1"></i>
                        {{ $course->duration_value }} {{ $course->duration_type }}
                    </span>
                    @if($course->has_certificate)
                    <span class="feature-badge text-dark">
                        <i class="fas fa-award text-success me-1"></i>
                        Certificate
                    </span>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Main Content -->
<div class="container py-5">
    <div class="row">
        <!-- Left Content -->
        <div class="col-lg-8">
            <!-- What You'll Learn -->
            @if($course->what_you_learn)
            <div class="section-card">
                <h3 class="h4 fw-bold mb-4">What you'll learn</h3>
                <div class="row">
                    @php
                        $learnPoints = array_slice(explode("\n", $course->what_you_learn), 0, 6);
                    @endphp
                    @foreach($learnPoints as $point)
                        @if(trim($point))
                        <div class="col-md-6 mb-3">
                            <div class="d-flex align-items-start">
                                <i class="fas fa-check text-success mt-1 me-3"></i>
                                <span class="text-dark">{{ trim($point) }}</span>
                            </div>
                        </div>
                        @endif
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Requirements -->
            @if($course->requirements)
            <div class="section-card">
                <h3 class="h4 fw-bold mb-4">Requirements</h3>
                <div class="learning-item">
                    <ul class="list-unstyled mb-0">
                        @php
                            $requirements = explode("\n", $course->requirements);
                        @endphp
                        @foreach($requirements as $requirement)
                            @if(trim($requirement))
                            <li class="mb-2">
                                <i class="fas fa-circle text-primary me-2 small"></i>
                                {{ trim($requirement) }}
                            </li>
                            @endif
                        @endforeach
                    </ul>
                </div>
            </div>
            @endif

            <!-- Description -->
            <div class="section-card">
                <h3 class="h4 fw-bold mb-4">Description</h3>
                <div class="text-dark line-height-lg">
                    {{ $course->description }}
                </div>
            </div>

            <!-- Instructor -->
            <div class="section-card">
                <h3 class="h4 fw-bold mb-4">Instructor</h3>
                <div class="d-flex align-items-start">
                    @if($course->teacher->profile_image)
                        <img src="{{ asset($course->teacher->profile_image) }}" 
                             alt="{{ $course->teacher->name }}" 
                             class="rounded-circle me-4" width="80" height="80" style="object-fit: cover;">
                    @else
                        <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-4" 
                             style="width: 80px; height: 80px; font-size: 24px;">
                            {{ substr($course->teacher->name, 0, 1) }}
                        </div>
                    @endif
                    <div>
                        <h5 class="fw-bold mb-2">{{ $course->teacher->name }}</h5>
                        <p class="text-muted mb-3">Professional Instructor</p>
                        <p class="text-dark mb-0">
                            Experienced educator with proven track record in student success and course delivery.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Sidebar -->
        <div class="col-lg-4">
            <div class="enroll-section p-4">
                <!-- Price -->
                <div class="text-center mb-4">
                    @if($course->price_type === 'free')
                        <div class="price-display text-success mb-2">FREE</div>
                    @else
                        <div class="price-display text-dark mb-2">${{ number_format($course->price, 2) }}</div>
                    @endif
                </div>

                <!-- Enroll Button -->
                <a href="{{ route('enrollment.form', $course->slug) }}" class="btn enroll-btn text-white mb-3">
                    @if($course->price_type === 'free')
                        Enroll Now
                    @else
                        Add to Cart
                    @endif
                </a>

                <div class="text-center mb-4">
                    <small class="text-muted">30-day money-back guarantee</small>
                </div>

                <!-- Course Features -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-3">This course includes:</h6>
                    <div class="learning-item">
                        <i class="fas fa-play-circle text-primary me-3"></i>
                        <span>Full lifetime access</span>
                    </div>
                    <div class="learning-item">
                        <i class="fas fa-mobile-alt text-primary me-3"></i>
                        <span>Access on mobile and TV</span>
                    </div>
                    @if($course->has_certificate)
                    <div class="learning-item">
                        <i class="fas fa-award text-primary me-3"></i>
                        <span>Certificate of completion</span>
                    </div>
                    @endif
                    <div class="learning-item">
                        <i class="fas fa-download text-primary me-3"></i>
                        <span>Downloadable resources</span>
                    </div>
                </div>

                <!-- Course Stats -->
                <div class="border-top pt-3">
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="stat-number">{{ $course->total_students }}+</div>
                            <div class="stat-label">Students</div>
                        </div>
                        <div class="col-4">
                            <div class="stat-number">{{ number_format($course->ratings, 1) }}</div>
                            <div class="stat-label">Rating</div>
                        </div>
                        <div class="col-4">
                            <div class="stat-number">{{ $course->duration_value }}</div>
                            <div class="stat-label">{{ $course->duration_type }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Share Course -->
            <div class="mt-4 text-center">
                <small class="text-muted d-block mb-2">Share this course</small>
                <div class="d-flex justify-content-center gap-2">
                    <a href="#" class="btn btn-outline-secondary btn-sm">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="#" class="btn btn-outline-secondary btn-sm">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="#" class="btn btn-outline-secondary btn-sm">
                        <i class="fab fa-linkedin-in"></i>
                    </a>
                    <a href="#" class="btn btn-outline-secondary btn-sm">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
