@extends('apps')

@section('content')
<style>
    .post-thumbnail {
        object-fit: cover;
        width: 100%;
        height: 100%;
        max-height: 250px;
        filter: brightness(60%);
        transition: filter 0.3s ease;
    }

    .post-thumbnail:hover {
        filter: brightness(80%);
    }

    .category-badge {
        background-color: #1dbf73;
        color: white;
        font-size: 0.75rem;
        padding: 0.25rem 0.6rem;
        border-radius: 0.25rem;
        position: absolute;
        top: 10px;
        left: 10px;
        z-index: 2;
    }

    .card-hover:hover {
        transform: translateY(-4px);
        transition: all 0.3s ease-in-out;
    }
</style>

<section class="page-title-section bg-dark cover-background theme-overlay">
    <div class="container">
        <div class="row text-center text-white">
            <div class="col-md-12">
                <h2 class="fw-bold mb-0 text-white">
                    Posts tagged with: <span class="text-white">{{ $tag }}</span>
                </h2>
                <ul class="breadcrumb bg-transparent justify-content-center mt-2">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}" class="text-white">Home</a></li> &nbsp;>
                    <li class="breadcrumb-item active text-white">Tag: {{ $tag }}</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<div class=" p-5 bg-light">
    @if($posts->count())
        <div class="row g-4">
            @foreach($posts as $post)
                <div class="col-lg-12 col-md-12">
                    <div class="card border-0 shadow-sm card-hover h-100 overflow-hidden">
                        <div class="row g-0 h-100 flex-column flex-md-row">
                            <!-- Image -->
                            <div class="col-md-5 position-relative">
                                <span class="category-badge">
                                    {{ $post->category->name }}
                                </span>
                                <img src="{{ asset('blogs/' . $post->image) }}" alt="{{ $post->title }}"
                                     class="post-thumbnail rounded-start w-100 h-100">
                            </div>
                            <!-- Content -->
                            <div class="col-md-7 d-flex flex-column">
                                <div class="card-body d-flex flex-column h-100 bg-white">
                                    <a href="{{ route('details', $post->slug) }}" class="text-decoration-none text-dark">
                                        <h5 class="card-title fw-bold">{{ $post->title }}</h5>
                                    </a>
                                    <p class="card-text small text-muted mb-3">{{ $post->short_description }}</p>
                                    <div class="mt-auto">
                                        <div class="d-flex align-items-center text-muted small mb-2" ><span style="margin-right: 3px;">Posted On :</span>
                                            <i class="fas fa-calendar me-1" style="margin-right: 3px;"></i>
                                             <span>{{ $post->created_at->format('M d, Y') }}</span>
                                        </div>
                                        <div class="d-flex flex-wrap gap-1">
                                            @foreach(explode(',', $post->tags) as $tagItem)
                                                <a href="{{ route('posts', trim($tagItem)) }}"
                                                   class="badge text-white"
                                                   style="background-color: #1dbf73;">
                                                    {{ trim($tagItem) }}
                                                </a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End Content -->
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="alert alert-warning mt-4">
            No posts found for this tag.
        </div>
    @endif
</div>

@endsection
