@include('header')

<!-- Page Title Section -->
<section class="page-title-section bg-img cover-background theme-overlay"
         data-overlay-dark="8"
         data-background="{{ asset('assets/images/bread.jpg') }}"
         style="background-image: url('{{ asset('assets/images/bread.jpg') }}');">
    <div class="container">
        <div class="row align-items-center text-center text-white">
            <div class="col-md-12">
                <h1 class="fw-bold display-5">{{ $service->title }}</h1>
                </div>
 <div class="col-md-12">
                        <ul>
                            <li><a href="{{ url('/') }}">Home</a></li>
                            <li><a href="{{route('about')}}">{{ $service->title }}</a></li>
                        </ul>
                    </div>

            </div>
        </div>
    </div>
</section>

<!-- Service Detail Section -->
<section class="py-5">
    <div class="container">
        <div class="row">

            <!-- Main Content -->
            <div class="col-lg-8 mb-5">
                <!-- Hero Image -->
                <div class="mb-4 position-relative rounded overflow-hidden shadow">
                    <img src="{{ asset('storage/services/' . $service->image_1) }}"
                         alt="{{ $service->title }}"
                         class="img-fluid w-100"
                         style="max-height:450px; object-fit:cover;">
                </div>

       

                <!-- Title & Short Desc -->
                <h2 class="fw-bold mb-3  text-center text-dark">{{ $service->title }}</h2>
                @if($service->short_description)
                    <p class="lead text-muted">{{ $service->short_description }}</p>
                @endif

                <!-- Full Description -->
                <div class=" p-4 rounded ">
                    {!! $service->description !!}
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- All Services -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header " style="background:#1dbf73;">
                        <h6 class="mb-0 fw-bold text-white">All Services</h6>
                    </div>
                    <ul class="list-group list-group-flush">
                        @foreach($serviceall as $s)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <a href="{{ route('detail', $s->slug) }}" class="text-decoration-none stretched-link">
                                    {{ $s->title }}
                                </a>
                                <i class="fas fa-angle-right text-dark"></i>
                            </li>
                        @endforeach
                    </ul>
                </div>

                <!-- Social Icons -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-dark ">
                        <h6 class="mb-0 fw-bold text-white">Follow Us</h6>
                    </div>
                    <div class="card-body text-center">
                        <a href="https://facebook.com" target="_blank" class="btn btn-outline-primary  mx-1" >
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="https://twitter.com" target="_blank" class="btn btn-outline-info  mx-1" >
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="https://instagram.com" target="_blank" class="btn btn-outline-danger  mx-1" >
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="https://linkedin.com" target="_blank" class="btn btn-outline-primary  mx-1" >
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                    </div>
                </div>

                <!-- Need Help -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header text-white" style="background:#1dbf73;">
                        <h6 class="mb-0 fw-bold text-white">Need Help?</h6>
                    </div>
                    <div class="card-body">
                        <p class="mb-3">Contact our support team for more information about this service.</p>
                        <a href="{{ url('/contact') }}" class="btn btn-outline-primary w-100">Contact Us</a>
                    </div>
                </div>
            </div>

        </div>

        <!-- Related Services Row -->
        @if($relatedServices->count())
            <hr class="my-5">
            <div class="row">
                <div class="col-12 text-center mb-4">
                    <h4 class="fw-bold text-dark">Related Services</h4>
                </div>
                @foreach($relatedServices as $related)
                    <div class="col-md-4 mb-4">
                        <div class="card h-100 shadow-sm border-0 hover-card">
                            <img src="{{ asset('storage/services/' . $related->image_1) }}" class="card-img-top" alt="{{ $related->title }}" style="height:200px; object-fit:cover;">
                            <div class="card-body d-flex flex-column">
                                <h6 class="card-title fw-bold">{{ $related->title }}</h6>
                                <p class="card-text small text-muted flex-grow-1">{{ $related->short }}</p>
                                <a href="{{ route('detail', $related->slug) }}" class="btn btn-success btn-sm mt-auto">Read More</a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</section>

@include('footer')

<!-- Additional CSS (place in <head> or before </body>) -->
<style>
.hover-card {
    transition: transform .2s;
}
.hover-card:hover {
    transform: translateY(-6px);
}
a:hover{
    color: #1dbf73;
}
</style>