<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\AdminHomeController;
use App\Http\Controllers\AdminAboutController;
use App\Http\Controllers\AdminServiceController;
use App\Http\Controllers\AdminSpecialtyController;
use App\Http\Controllers\AdminFaqController;
use App\Http\Controllers\AdminSettingController;
use App\Http\Controllers\AdminContactController;
use App\Http\Controllers\AdminUserController;
use App\Http\Controllers\BlogCategoryController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\AppointmentController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\CourseCategoryController;
use App\Http\Controllers\TeacherController;
use App\Http\Controllers\EnrollmentController;
use App\Http\Controllers\AboutPageController;


// Admin Authentication Routes
Route::get('/login', [AdminAuthController::class, 'showLoginForm'])->name('admin.login');
Route::post('/login', [AdminAuthController::class, 'login'])->name('admin.login.submit');
Route::post('/logout', [AdminAuthController::class, 'logout'])->name('admin.logout');

// Protected Admin Routes
Route::middleware('admin.auth')->group(function () {
    // Dashboard
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
        Route::resource('categories', BlogCategoryController::class)->names([     'index' => 'admin.categories.index',
        'create' => 'admin.categories.create',
        'store' => 'admin.categories.store',
        'show' => 'admin.categories.show',
        'edit' => 'admin.categories.edit',
        'update' => 'admin.categories.update',
        'destroy' => 'admin.categories.destroy',]);


Route::resource('course', CourseController::class)->names([
    'index' => 'admin.courses.index',
    'create' => 'admin.courses.create',
    'store' => 'admin.courses.store',
    'show' => 'admin.courses.show',
    'edit' => 'admin.courses.edit',
    'update' => 'admin.courses.update',
    'destroy' => 'admin.courses.destroy',
]);




Route::resource('aboutus', AboutPageController::class)->names([
    'index' => 'admin.about.index',
    'create' => 'admin.about.create',
    'store' => 'admin.about.store',
    'show' => 'admin.about.show',
    'edit' => 'admin.about.edit',
    'update' => 'admin.about.update',
    'destroy' => 'admin.about.destroy',
])->parameter('aboutus', 'about');

Route::resource('enrollment', EnrollmentController::class)->names([
    'index' => 'admin.enrollments.index',
    'create' => 'admin.enrollments.create',
    'store' => 'admin.enrollments.store',
    'show' => 'admin.enrollments.show',
    'edit' => 'admin.enrollments.edit',
    'update' => 'admin.enrollments.update',
    'destroy' => 'admin.enrollments.destroy',
]);


Route::resource('course_categories', CourseCategoryController::class)->names([
    'index' => 'admin.course_category.index',
    'create' => 'admin.course_category.create',
    'store' => 'admin.course_category.store',
    'show' => 'admin.course_category.show',
    'edit' => 'admin.course_category.edit',
    'update' => 'admin.course_category.update',
    'destroy' => 'admin.course_category.destroy',
])->parameters([
    'course_categories' => 'category'
]);

Route::resource('instructor', TeacherController::class)->names([
    'index' => 'admin.teachers.index',
    'create' => 'admin.teachers.create',
    'store' => 'admin.teachers.store',
    'show' => 'admin.teachers.show',
    'edit' => 'admin.teachers.edit',
    'update' => 'admin.teachers.update',
    'destroy' => 'admin.teachers.destroy',
])->parameters([
    'instructor' => 'teacher'
]);


Route::resource('/appointments', AppointmentController::class)->names([
    'index' => 'admin.appointments.index',
    'create' => 'admin.appointments.create',
    'store' => 'admin.appointments.store',
    'show' => 'admin.appointments.show',
    'edit' => 'admin.appointments.edit',
    'update' => 'admin.appointments.update',
    'destroy' => 'admin.appointments.destroy',
]);


Route::resource('/posts', BlogController::class)->names([     'index' => 'admin.posts.index',
        'create' => 'admin.posts.create',
        'store' => 'admin.posts.store',
        'show' => 'admin.posts.show',
        'edit' => 'admin.posts.edit',
        'update' => 'admin.posts.update',
        'destroy' => 'admin.posts.destroy',]);

    // Home Content Management
    Route::resource('homes', AdminHomeController::class)->names([
        'index' => 'admin.home.index',
        'create' => 'admin.home.create',
        'store' => 'admin.home.store',
        'show' => 'admin.home.show',
        'edit' => 'admin.home.edit',
        'update' => 'admin.home.update',
        'destroy' => 'admin.home.destroy',
    ]);
    
    // About Content Management
    // Route::resource('about', AdminAboutController::class)->names([
    //     'index' => 'admin.about.index',
    //     'create' => 'admin.about.create',
    //     'store' => 'admin.about.store',
    //     'show' => 'admin.about.show',
    //     'edit' => 'admin.about.edit',
    //     'update' => 'admin.about.update',
    //     'destroy' => 'admin.about.destroy',
    // ]);
    
    // Services Management
    Route::resource('service', AdminServiceController::class)->names([
        'index' => 'admin.services.index',
        'create' => 'admin.services.create',
        'store' => 'admin.services.store',
        'show' => 'admin.services.show',
        'edit' => 'admin.services.edit',
        'update' => 'admin.services.update',
        'destroy' => 'admin.services.destroy',
    ]);
    
    // Specialties Management
 Route::resource('specialtie', AdminSpecialtyController::class)->parameters([
    'specialtie' => 'specialty'
])->names([
        'index' => 'admin.specialties.index',
        'create' => 'admin.specialties.create',
        'store' => 'admin.specialties.store',
        'show' => 'admin.specialties.show',
        'edit' => 'admin.specialties.edit',
        'update' => 'admin.specialties.update',
        'destroy' => 'admin.specialties.destroy',
    ]);
    
    // FAQs Management
    Route::resource('faqs', AdminFaqController::class)->names([
        'index' => 'admin.faqs.index',
        'create' => 'admin.faqs.create',
        'store' => 'admin.faqs.store',
        'show' => 'admin.faqs.show',
        'edit' => 'admin.faqs.edit',
        'update' => 'admin.faqs.update',
        'destroy' => 'admin.faqs.destroy',
    ]);
    
    // Settings Management
    Route::resource('admin-settings', AdminSettingController::class)->names([
        'index' => 'admin.settings.index',
        'create' => 'admin.settings.create',
        'store' => 'admin.settings.store',
        'show' => 'admin.settings.show',
        'edit' => 'admin.settings.edit',
        'update' => 'admin.settings.update',
        'destroy' => 'admin.settings.destroy',
    ]);
    
    // Contact Messages Management
    Route::resource('contacts', AdminContactController::class)->only([
        'index', 'show', 'destroy'
    ])->names([
        'index' => 'admin.contacts.index',
        'show' => 'admin.contacts.show',
        'destroy' => 'admin.contacts.destroy',
    ]);
    
    // Admin Users Management
    Route::resource('admin-users', AdminUserController::class)->names([
        'index' => 'admin.admin-users.index',
        'create' => 'admin.admin-users.create',
        'store' => 'admin.admin-users.store',
        'show' => 'admin.admin-users.show',
        'edit' => 'admin.admin-users.edit',
        'update' => 'admin.admin-users.update',
        'destroy' => 'admin.admin-users.destroy',
    ]);

// reviews

    Route::resource('review', \App\Http\Controllers\AdminTestimonialController::class)->names('admin.testimonials');

});

