<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\BlogCommentController;
use App\Http\Controllers\AppointmentController;
use App\Http\Controllers\CourseServicesController;
use App\Http\Controllers\EnrollmentController;

// ✅ Public routes
Route::get('/', [FrontController::class, 'index'])->name('index');
Route::get('/services', [FrontController::class, 'services'])->name('services');
Route::get('/instructors', [FrontController::class, 'teacher'])->name('teacher');
Route::get('/instructors/{teacher:slug}', [FrontController::class, 'teacherDetails'])->name('teacherdetails');
Route::get('/specialties', [FrontController::class, 'specialties'])->name('specialties');
Route::get('/post', [FrontController::class, 'blogs'])->name('blogs');
Route::get('/faq', [FrontController::class, 'faq'])->name('faq');
Route::post('/book-appointment', [AppointmentController::class, 'store'])->name('appointments.store');
Route::get('/courses-quranezy', [CourseServicesController::class, 'frontendIndex'])->name('courses-quran');
Route::get('/courses-quranezy/{slug}', [CourseServicesController::class, 'shows'])->name('nadeem');

Route::get('/courses/category/{slug}', [CourseServicesController::class, 'coursesByCategory'])
    ->name('courses.by.category');

Route::get('/enroll/{slug}', [EnrollmentController::class, 'showEnrollmentForm'])->name('enrollment.form');
Route::post('/enroll/{course}/process', [EnrollmentController::class, 'processEnrollment'])->name('enrollment.process');

Route::get('/contact-ayzmedflow', [FrontController::class, 'contact'])->name('contact');
Route::post('/contact-ayzmedflow', [FrontController::class, 'storeContact'])->name('contact.store');
Route::get('/about-us', [FrontController::class, 'about'])->name('about');
Route::get('/services/{slug}', [FrontController::class, 'detail'])->name('detail');

Route::get('/specialties/{slug}', [FrontController::class, 'sepcialtyDetail'])->name('specialtydetail');

Route::get('blogs/{slug}', [FrontController::class, 'details'])->name('details');
Route::post('blogs/{post}/comment', [BlogCommentController::class, 'store'])->name('comment');
Route::get('/tags/{tag}', [FrontController::class, 'postsByTag'])->name('posts');
Route::get('/category/{id}', [FrontController::class, 'categoryPosts'])->name('category.posts');
