<!-- resources/views/admin/courses/show.blade.php -->


<?php $__env->startSection('title', $course->title); ?>
<?php $__env->startSection('page-title', 'Course Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-8">
        <div class="card shadow">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <h4 class="mb-0"><i class="fas fa-book"></i> Course Details</h4>
                <div class="btn-group">
                    <a href="<?php echo e(route('admin.courses.edit', $course)); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <form action="<?php echo e(route('admin.courses.destroy', $course)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger btn-sm" 
                                onclick="return confirm('Are you sure?')">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-4">
                        <?php if($course->image): ?>
                            <img src="<?php echo e(asset($course->image)); ?>" 
                                 class="img-fluid rounded" alt="<?php echo e($course->title); ?>">
                        <?php else: ?>
                            <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                 style="height: 200px;">
                                <i class="fas fa-image text-muted" style="font-size: 3rem;"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                        <h2 class="mb-3"><?php echo e($course->title); ?></h2>
                        
                        <div class="d-flex flex-wrap gap-2 mb-3">
                            <?php if($course->label): ?>
                                <span class="badge label-<?php echo e($course->label); ?> text-white bg-success px-3 py-2">
                                    <?php echo e(ucfirst($course->label)); ?>

                                </span>
                            <?php endif; ?>
                            <span class="badge bg-secondary"><?php echo e(ucfirst($course->level)); ?></span>
                            <span class="badge bg-info"><?php echo e($course->duration_value); ?> <?php echo e($course->duration_type); ?></span>
                            <?php if($course->has_certificate): ?>
                                <span class="badge bg-success">
                                    <i class="fas fa-award"></i> Certificate Included
                                </span>
                            <?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <div class="rating-stars h5">
                                <?php
                                    $fullStars = floor($course->ratings);
                                    $halfStar = ($course->ratings - $fullStars) >= 0.5 ? 1 : 0;
                                    $emptyStars = 5 - ($fullStars + $halfStar);
                                ?>

                                <?php for($i = 1; $i <= $fullStars; $i++): ?>
                                    <i class="fas fa-star text-warning"></i>
                                <?php endfor; ?>

                                <?php if($halfStar): ?>
                                    <i class="fas fa-star-half-alt text-warning"></i>
                                <?php endif; ?>

                                <?php for($i = 1; $i <= $emptyStars; $i++): ?>
                                    <i class="far fa-star text-warning"></i>
                                <?php endfor; ?>
                                <span class="text-muted">(<?php echo e(number_format($course->ratings, 1)); ?>)</span>
                            </div>
                        </div>

                        <div class="row text-center mb-3">
                            <div class="col-4">
                                <div class="border-end">
                                    <h5 class="text-primary mb-1"><?php echo e($course->total_students); ?></h5>
                                    <small class="text-muted">Students</small>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="border-end">
                                    <h5 class="text-success mb-1"><?php echo e($course->duration_value); ?></h5>
                                    <small class="text-muted"><?php echo e(ucfirst($course->duration_type)); ?></small>
                                </div>
                            </div>
                            <div class="col-4">
                                <h5 class="text-warning mb-1"><?php echo e($course->category->name); ?></h5>
                                <small class="text-muted">Category</small>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="mb-0">
                                    <?php if($course->price_type === 'free'): ?>
                                        <span class="text-success">Free</span>
                                    <?php else: ?>
                                        <span class="text-primary">$<?php echo e(number_format($course->price, 2)); ?></span>
                                    <?php endif; ?>
                                </h4>
                            </div>
                            <div class="text-end">
                                <small class="text-muted d-block">Instructor</small>
                                <strong><?php echo e($course->teacher->name); ?></strong>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-4">
                    <h5>Description</h5>
                    <p class="text-muted"><?php echo e($course->description); ?></p>
                </div>

                <?php if($course->requirements): ?>
                <div class="mb-4">
                    <h5>Requirements</h5>
                    <div class="text-muted">
                        <?php $__currentLoopData = explode("\n", $course->requirements); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(trim($requirement)): ?>
                                <div class="d-flex align-items-center mb-1">
                                    <i class="fas fa-check text-success me-2"></i>
                                    <span><?php echo e($requirement); ?></span>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if($course->what_you_learn): ?>
                <div class="mb-4">
                    <h5>What You'll Learn</h5>
                    <div class="text-muted">
                        <?php $__currentLoopData = explode("\n", $course->what_you_learn); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $learning): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(trim($learning)): ?>
                                <div class="d-flex align-items-center mb-1">
                                    <i class="fas fa-check text-primary me-2"></i>
                                    <span><?php echo e($learning); ?></span>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="fas fa-info-circle"></i> Course Information</h5>
            </div>
            <div class="card-body">
                <div class="list-group list-group-flush">
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Category:</span>
                        <strong><?php echo e($course->category->name); ?></strong>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Level:</span>
                        <span class="badge bg-secondary"><?php echo e(ucfirst($course->level)); ?></span>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Duration:</span>
                        <strong><?php echo e($course->duration_value); ?> <?php echo e($course->duration_type); ?></strong>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Price Type:</span>
                        <span class="badge bg-<?php echo e($course->price_type === 'free' ? 'success' : 'primary'); ?>">
                            <?php echo e(ucfirst($course->price_type)); ?>

                        </span>
                    </div>
                    <?php if($course->price_type === 'paid'): ?>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Price:</span>
                        <strong>$<?php echo e(number_format($course->price, 2)); ?></strong>
                    </div>
                    <?php endif; ?>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Certificate:</span>
                        <span class="badge bg-<?php echo e($course->has_certificate ? 'success' : 'secondary'); ?>">
                            <?php echo e($course->has_certificate ? 'Yes' : 'No'); ?>

                        </span>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Total Students:</span>
                        <strong><?php echo e($course->total_students); ?></strong>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Status:</span>
                        <span class="badge bg-<?php echo e($course->is_active ? 'success' : 'danger'); ?>">
                            <?php echo e($course->is_active ? 'Active' : 'Inactive'); ?>

                        </span>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Featured:</span>
                        <span class="badge bg-<?php echo e($course->is_featured ? 'warning' : 'secondary'); ?>">
                            <?php echo e($course->is_featured ? 'Yes' : 'No'); ?>

                        </span>
                    </div>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>Created:</span>
                        <small class="text-muted"><?php echo e($course->created_at->format('M d, Y')); ?></small>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="fas fa-chalkboard-teacher"></i> Teacher Information</h5>
            </div>
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <?php if($course->teacher->profile_image): ?>
                        <img src="<?php echo e(asset($course->teacher->profile_image)); ?>" 
                             class="rounded-circle me-3" width="50" height="50" 
                             style="object-fit: cover;" alt="<?php echo e($course->teacher->name); ?>">
                    <?php else: ?>
                        <div class="bg-light rounded-circle d-flex align-items-center justify-content-center me-3" 
                             style="width: 50px; height: 50px;">
                            <i class="fas fa-user text-muted"></i>
                        </div>
                    <?php endif; ?>
                    <div>
                        <h6 class="mb-0"><?php echo e($course->teacher->name); ?></h6>
                        <?php if($course->teacher->specialization): ?>
                            <small class="text-muted"><?php echo e($course->teacher->specialization); ?></small>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if($course->teacher->email): ?>
                    <div class="mb-2">
                        <small><i class="fas fa-envelope text-muted me-2"></i> <?php echo e($course->teacher->email); ?></small>
                    </div>
                <?php endif; ?>
                <?php if($course->teacher->experience_years > 0): ?>
                    <div class="mb-2">
                        <small><i class="fas fa-briefcase text-muted me-2"></i> <?php echo e($course->teacher->experience_years); ?> years experience</small>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="mt-3 text-center">
            <a href="<?php echo e(route('admin.courses.index')); ?>" class="btn btn-outline-primary">
                <i class="fas fa-arrow-left"></i> Back to Courses
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/courses/show.blade.php ENDPATH**/ ?>