<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    
    <meta name="author" content="<?php echo e($settings->site_name ?? 'AyzMedFlow'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="keywords" content="<?php echo e($settings->meta_keywords ?? 'medical billing, healthcare, medical practice, billing solutions, revenue cycle management'); ?>">
    <meta name="description" content="<?php echo e($settings->meta_description ?? 'AyzMedFlow - Trusted medical billing experts for your practice. Seamless, accurate, and reliable medical billing solutions.'); ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($settings->site_name ?? 'AyzMedFlow'); ?> - Medical Billing Company">
    <meta property="og:description" content="<?php echo e($settings->meta_description ?? 'Trusted medical billing experts for your practice'); ?>">
    <?php if($settings->logo): ?>
    <meta property="og:image" content="<?php echo e(asset($settings->logo)); ?>">
    <?php endif; ?>
<!-- Fonts -->
<link href="https://fonts.googleapis.com" rel="preconnect">
<link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&display=swap" rel="stylesheet">
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($settings->site_name ?? 'AyzMedFlow'); ?> - Medical Billing Company">
    <meta property="twitter:description" content="<?php echo e($settings->meta_description ?? 'Trusted medical billing experts for your practice'); ?>">
    <!-- Vendor CSS Files -->
    <link href="<?php echo e(asset('assets/vendor/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/bootstrap-icons/bootstrap-icons.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/vendor/swiper/swiper-bundle.min.css')); ?>" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

    <!-- Main CSS File -->
    <link href="<?php echo e(asset('assets/css/main.css')); ?>" rel="stylesheet">

    <style>
        /* Header logo */
        .navbar-brand img {
            width: 150px;      /* Desktop default width */
            height: auto;      /* Maintain 3:2 ratio automatically */
        }

        /* Tablet */
        @media (max-width: 992px) {
            .navbar-brand img {
                width: 120px;
            }
        }

        /* Mobile */
        @media (max-width: 576px) {
            .navbar-brand img {
                width: 120px;
            }
        }

        .header{
            padding: 2px!important;
        }

        .btn-getstarted {
            padding: 5px 12px!important; /* bada touch area */
            font-size: 18px!important;    /* readable text */
            border-radius: 0px!important; /* thoda rounded for modern look */
            display: inline-flex;
            align-items: center;
            gap: 8px;    
            border-radius: 5px!important;  
            margin-left: 29px!important;
        }

        @media (max-width: 900px) {
            .btn-getstarted {
                font-size: 14px!important;    /* fit in small screens */
                justify-content: center!important;
                margin-left:5px!important ;
                background: #1dbf73!important;
            }
        }
        .header .btn-getstarted:hover,
        .header .btn-getstarted:focus:hover {
          background: #36454F!important;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <?php echo $__env->make('header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
    <!-- Main Content -->
    <?php echo $__env->yieldContent('content'); ?>
    
    <!-- Footer -->
    <?php echo $__env->make('footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Scripts -->
 <script src="<?php echo e(asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/php-email-form/validate.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/aos/aos.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/purecounter/purecounter_vanilla.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/swiper/swiper-bundle.min.js')); ?>"></script>

<!-- Main JS File -->
<script src="<?php echo e(asset('assets/js/mains.js')); ?>"></script>
</body>
</html><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/apps.blade.php ENDPATH**/ ?>