
<?php $__env->startSection('title', 'Testimonials'); ?>
<?php $__env->startSection('page-title', 'Testimonials'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-comments text-success me-2"></i>Testimonials</h2>
    <a href="<?php echo e(route('admin.testimonials.create')); ?>" class="btn btn-success rounded-pill px-4">
      <i class="fas fa-plus me-2"></i>Add
    </a>
  </div>

  <div class="card border-0 rounded-4 shadow-sm">
    <div class="card-body p-4">
      <?php if($testimonials->count()): ?>
        <div class="table-responsive">
          <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>#</th><th>Image</th><th>Name</th><th>Profession</th><th>Stars</th><th>Status</th><th class="text-center">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($t->id); ?></td>
                <td>
          <img src="<?php echo e(asset( $t->image)); ?>" alt="" class="rounded-3" style="width: 48px; height: 48px; object-fit: cover;">
                </td>
                <td><?php echo e($t->client_name); ?></td>
                <td><?php echo e($t->client_profession); ?></td>
                <td>
                  <span class="text-warning">
                    <?php for($i=1;$i<=$t->stars;$i++): ?><i class="fas fa-star"></i><?php endfor; ?>
                    <?php for($i=$t->stars+1;$i<=5;$i++): ?><i class="far fa-star"></i><?php endfor; ?>
                  </span>
                </td>
                <td>
                  <span class="badge rounded-pill <?php echo e($t->is_active ? 'bg-success' : 'bg-secondary'); ?>">
                    <?php echo e($t->is_active ? 'Active' : 'Inactive'); ?>

                  </span>
                </td>
                <td class="text-center">
                  <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown"><i class="fas fa-ellipsis-v"></i></button>
                    <ul class="dropdown-menu dropdown-menu-end">
                      <li><a class="dropdown-item" href="<?php echo e(route('admin.testimonials.edit', $t)); ?>"><i class="fas fa-edit me-2"></i>Edit</a></li>
                      <li>
                        <form action="<?php echo e(route('admin.testimonials.destroy', $t)); ?>" method="POST" onsubmit="return confirm('Delete?')">
                          <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                          <button type="submit" class="dropdown-item text-danger"><i class="fas fa-trash me-2"></i>Delete</button>
                        </form>
                      </li>
                    </ul>
                  </div>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
        <?php echo e($testimonials->links('pagination::bootstrap-4')); ?>

      <?php else: ?>
        <div class="text-center py-5">
          <i class="fas fa-comments fa-3x text-success opacity-75 mb-3"></i>
          <h5>No testimonials yet</h5>
          <a href="<?php echo e(route('admin.testimonials.create')); ?>" class="btn btn-success rounded-pill px-4">Add First</a>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/testimonials/index.blade.php ENDPATH**/ ?>