<?php echo $__env->make('header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- Page Title Section -->
<section class="page-title-section bg-img cover-background theme-overlay"
         data-overlay-dark="8"
         data-background="<?php echo e(asset('assets/images/bread.jpg')); ?>"
         style="background-image: url('<?php echo e(asset('assets/images/bread.jpg')); ?>');">
    <div class="container">
        <div class="row align-items-center text-center text-white">
            <div class="col-md-12">
                <h1 class="fw-bold display-5"><?php echo e($specialslug->title); ?></h1>
                </div>
 <div class="col-md-12">
                        <ul>
                            <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                            <li><a href="<?php echo e(route('about')); ?>"><?php echo e($specialslug->title); ?></a></li>
                        </ul>
                    </div>

            </div>
        </div>
    </div>
</section>

<!-- Service Detail Section -->
<section class="py-5">
    <div class="container">
        <div class="row">

            <!-- Main Content -->
            <div class="col-lg-8 mb-5">
                <!-- Hero Image -->
                <div class="mb-4 position-relative rounded overflow-hidden shadow">
                    <img src="<?php echo e($specialslug->image_url); ?>"
                         alt="<?php echo e($specialslug->title); ?>"
                         class="img-fluid w-100"
                         style="max-height:450px; object-fit:cover;">
                </div>

       

                <!-- Title & Short Desc -->
                <?php if($specialslug->short): ?>
                    <h2 class="mt-5 text-muted text-center text-uppercase" style="color: black!important;"><?php echo e($specialslug->short); ?></h2>
                <?php endif; ?>

                <!-- Full Description -->
                <div class=" p-4 rounded ">
                    <?php echo $specialslug->description; ?>

                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- All Services -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header " style="background:#1dbf73;">
                        <h6 class="mb-0 fw-bold text-white">All Services</h6>
                    </div>
                    <ul class="list-group list-group-flush">
                        <?php $__currentLoopData = $specialtyall; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <a href="<?php echo e(route('specialtydetail', $s->slug)); ?>" class="text-decoration-none stretched-link">
                                    <?php echo e($s->title); ?>

                                </a>
                                <i class="fas fa-angle-right text-dark"></i>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <!-- Social Icons -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-dark ">
                        <h6 class="mb-0 fw-bold text-white">Follow Us</h6>
                    </div>
                    <div class="card-body text-center">
                        <a href="<?php echo e($settings->facebook_url); ?>" target="_blank" class="btn btn-outline-primary  mx-1" >
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="<?php echo e($settings->tiktok_url); ?>" target="_blank" class="btn btn-outline-info  mx-1" >
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="<?php echo e($settings->instagram_url); ?>" target="_blank" class="btn btn-outline-danger  mx-1" >
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="<?php echo e($settings->linkedin_url); ?>" target="_blank" class="btn btn-outline-primary  mx-1" >
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                    </div>
                </div>

                <!-- Need Help -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header text-white" style="background:#1dbf73;">
                        <h6 class="mb-0 fw-bold text-white">Need Help?</h6>
                    </div>
                    <div class="card-body">
                        <p class="mb-3">Contact our support team for more information about this service.</p>
                        <a href="<?php echo e(url('/contact')); ?>" class="btn btn-outline-primary w-100">Contact Us</a>
                    </div>
                </div>
            </div>

        </div>

        <!-- Related Services Row -->
        <?php if($relatedSpecialty->count()): ?>
            <hr class="my-5">
            <div class="row">
                <div class="col-12 text-center mb-4">
                    <h4 class="fw-bold text-dark">Related Services</h4>
                </div>
                <?php $__currentLoopData = $relatedSpecialty; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 mb-4">
                        <div class="card h-100 shadow-sm border-0 hover-card">
                            <img src="<?php echo e($related->image_url); ?>" class="card-img-top" alt="<?php echo e($related->title); ?>" style="height:200px; object-fit:cover;">
                            <div class="card-body d-flex flex-column">
                                <h6 class="card-title fw-bold"><?php echo e($related->title); ?></h6>
                                <p class="card-text small text-muted flex-grow-1"><?php echo e($related->short); ?></p>
                                <a href="<?php echo e(route('specialtydetail', $related->slug)); ?>" class="btn btn-success btn-sm mt-auto">Read More</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php echo $__env->make('footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- Additional CSS (place in <head> or before </body>) -->
<style>
.hover-card {
    transition: transform .2s;
}
.hover-card:hover {
    transform: translateY(-6px);
}
a:hover{
    color: #1dbf73;
}
</style><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/specialty-detail.blade.php ENDPATH**/ ?>