

<?php $__env->startSection('title', 'Appointment Details'); ?>
<?php $__env->startSection('page-title', 'Appointment Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
  <div class="card shadow-sm border-0">
    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
      <h5 class="mb-0">
        <i class="fas fa-calendar-check me-2"></i> Appointment Details
      </h5>
      <a href="<?php echo e(route('admin.appointments.index')); ?>" class="btn btn-light btn-sm">
        <i class="fas fa-arrow-left me-1"></i> Back to List
      </a>
    </div>

    <div class="card-body">
      <div class="row gy-3">
        <div class="col-md-6">
          <div class="border rounded p-3">
            <h6 class="text-muted">Name</h6>
            <p class="mb-0 fw-semibold"><?php echo e($appointment->name); ?></p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="border rounded p-3">
            <h6 class="text-muted">Email</h6>
            <p class="mb-0 fw-semibold"><?php echo e($appointment->email); ?></p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="border rounded p-3">
            <h6 class="text-muted">Phone</h6>
            <p class="mb-0 fw-semibold"><?php echo e($appointment->phone); ?></p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="border rounded p-3">
            <h6 class="text-muted">Appointment Date</h6>
            <p class="mb-0 fw-semibold"><?php echo e(\Carbon\Carbon::parse($appointment->appointment_date)->format('d M Y')); ?></p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="border rounded p-3">
            <h6 class="text-muted">Appointment Time</h6>
            <p class="mb-0 fw-semibold"><?php echo e(\Carbon\Carbon::parse($appointment->appointment_time)->format('h:i A')); ?></p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="border rounded p-3">
            <h6 class="text-muted">Submitted At</h6>
            <p class="mb-0 fw-semibold"><?php echo e($appointment->created_at->format('d M Y, h:i A')); ?></p>
          </div>
        </div>

        <div class="col-12">
          <div class="border rounded p-3">
            <h6 class="text-muted">Message</h6>
            <p class="mb-0 fw-semibold"><?php echo e($appointment->message ?? 'N/A'); ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/appointments/show.blade.php ENDPATH**/ ?>