

<?php $__env->startSection('content'); ?>

<style >
    .breadcrumb{
        background: inherit!important;
    }
</style>
<div class="bg-dark py-4 mb-4">
    <div class="container text-white">
        <h4 class="mb-1 text-white"><?php echo e($category->name); ?> Posts</h4>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" class="text-white text-decoration-none">Home</a></li> &nbsp; >
                <li class="breadcrumb-item active text-white" aria-current="page"><?php echo e($category->name); ?></li>
            </ol>
        </nav>
    </div>
</div>


<div class="container pb-5">
    <?php if($posts->count()): ?>
        <div class="row g-4">
            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <img src="<?php echo e(asset('blogs/' . $post->image)); ?>" class="card-img-top" alt="<?php echo e($post->title); ?>">
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title fw-bold"><?php echo e($post->title); ?></h5>
                            <p class="card-text small text-muted"><?php echo e($post->short_description); ?></p>
                            <div class="mt-auto d-flex justify-content-between align-items-center small text-muted">
                                <span>
                                    <i class="fas fa-calendar-alt me-1"></i>
                                    Posted on <?php echo e($post->created_at->format('M d, Y')); ?>

                                </span>
                                <a href="<?php echo e(route('details', $post->slug)); ?>" class="btn btn-sm" style="background-color: #1dbf73; color: #fff;">Read More</a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

<div class="mt-4 py-2 px-3 rounded border d-flex flex-column flex-md-row justify-content-between align-items-center bg-light">
    <div class="small text-muted mb-2 mb-md-0">
        Showing <?php echo e($posts->firstItem()); ?> to <?php echo e($posts->lastItem()); ?> of <?php echo e($posts->total()); ?> results
    </div>
    <nav>
        <?php echo e($posts->onEachSide(1)->links('pagination::bootstrap-5')); ?>

    </nav>
</div>



    <?php else: ?>
        <div class="alert alert-warning mt-4">No posts found for this category.</div>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('apps', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/category.blade.php ENDPATH**/ ?>