

<?php $__env->startSection('title', 'Appointments'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <h2 class="fw-bold text-dark mb-4">
        <i class="fas fa-calendar-check me-2 text-primary"></i>Appointments
    </h2>

    <?php if(session('success')): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Deleted!',
                text: '<?php echo e(session("success")); ?>',
                confirmButtonColor: '#3085d6'
            });
        </script>
    <?php endif; ?>

    <div class="card shadow-sm border-0">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark text-nowrap">
                        <tr class="align-middle text-center">
                            <th>#</th>
                            <th>Type</th>
                            <th>Practice Name</th>
                            <th>Name</th>
                            <th>Monthly Collections</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th>Message</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $appt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="text-center">
                                <td><?php echo e($appointments->firstItem() + $key); ?></td>
                                <td>
                                    <span class="badge bg-primary"><?php echo e($appt->type); ?></span>
                                </td>
                                <td><?php echo e($appt->practice_name); ?></td>
                                <td><?php echo e($appt->name); ?></td>
                                <td><?php echo e($appt->monthly_collections); ?></td>
                                <td><?php echo e($appt->email); ?></td>
                                <td><?php echo e($appt->phone); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($appt->appointment_date)->format('d M Y')); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($appt->appointment_time)->format('h:i A')); ?></td>
                                <td class="text-start"><?php echo e(Str::limit($appt->message, 50)); ?></td>
                                <td>
                                    <div class="d-flex justify-content-center gap-1">
                                        <a href="<?php echo e(route('admin.appointments.show', $appt)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <form method="POST" action="<?php echo e(route('admin.appointments.destroy', $appt->id)); ?>" class="d-inline delete-form">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger delete-btn">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="11" class="text-center text-muted py-4">No appointments found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php if($appointments->hasPages()): ?>
            <div class="card-footer d-flex justify-content-center py-3">
                <?php echo e($appointments->links('pagination::bootstrap-5')); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.querySelectorAll('.delete-form').forEach(form => {
        form.addEventListener('submit', function (e) {
            e.preventDefault();
            Swal.fire({
                title: 'Are you sure?',
                text: "This appointment will be permanently deleted!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/appointments/index.blade.php ENDPATH**/ ?>