<!-- resources/views/admin/teachers/show.blade.php -->


<?php $__env->startSection('title', $teacher->name); ?>
<?php $__env->startSection('page-title', 'Teacher Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <?php if($teacher->profile_image): ?>
                    <img src="<?php echo e(asset($teacher->profile_image)); ?>" 
                         class="rounded-circle mb-3" width="150" height="150" 
                         style="object-fit: cover;" alt="<?php echo e($teacher->name); ?>">
                <?php else: ?>
                    <div class="bg-light rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3" 
                         style="width: 150px; height: 150px;">
                        <i class="fas fa-user fa-3x text-muted"></i>
                    </div>
                <?php endif; ?>
                
                <h4><?php echo e($teacher->name); ?></h4>
                <?php if($teacher->specialization): ?>
                    <p class="text-muted"><?php echo e($teacher->specialization); ?></p>
                <?php endif; ?>
                
                <div class="d-flex justify-content-center gap-2 mb-3">
                    <?php if($teacher->is_active): ?>
                        <span class="badge bg-success">Active</span>
                    <?php else: ?>
                        <span class="badge bg-danger">Inactive</span>
                    <?php endif; ?>
                    
                    <?php if($teacher->is_featured): ?>
                        <span class="badge bg-warning">Featured</span>
                    <?php endif; ?>
                </div>

                <!-- Social Links -->
                <div class="d-flex justify-content-center gap-3 mb-3">
                    <?php if($teacher->facebook_url): ?>
                        <a href="<?php echo e($teacher->facebook_url); ?>" target="_blank" class="text-primary">
                            <i class="fab fa-facebook fa-lg"></i>
                        </a>
                    <?php endif; ?>
                    <?php if($teacher->twitter_url): ?>
                        <a href="<?php echo e($teacher->twitter_url); ?>" target="_blank" class="text-info">
                            <i class="fab fa-twitter fa-lg"></i>
                        </a>
                    <?php endif; ?>
                    <?php if($teacher->linkedin_url): ?>
                        <a href="<?php echo e($teacher->linkedin_url); ?>" target="_blank" class="text-primary">
                            <i class="fab fa-linkedin fa-lg"></i>
                        </a>
                    <?php endif; ?>
                    <?php if($teacher->website_url): ?>
                        <a href="<?php echo e($teacher->website_url); ?>" target="_blank" class="text-success">
                            <i class="fas fa-globe fa-lg"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header bg-light">
                <h6 class="mb-0"><i class="fas fa-info-circle"></i> Contact Information</h6>
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong><i class="fas fa-envelope text-muted me-2"></i> Email:</strong><br>
                    <a href="mailto:<?php echo e($teacher->email); ?>"><?php echo e($teacher->email); ?></a>
                </div>
                <?php if($teacher->phone): ?>
                <div class="mb-2">
                    <strong><i class="fas fa-phone text-muted me-2"></i> Phone:</strong><br>
                    <a href="tel:<?php echo e($teacher->phone); ?>"><?php echo e($teacher->phone); ?></a>
                </div>
                <?php endif; ?>
                <?php if($teacher->experience_years > 0): ?>
                <div class="mb-2">
                    <strong><i class="fas fa-briefcase text-muted me-2"></i> Experience:</strong><br>
                    <?php echo e($teacher->experience_years); ?> years
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Teacher Information</h5>
                <div class="btn-group">
                    <a href="<?php echo e(route('admin.teachers.edit', $teacher)); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="<?php echo e(route('admin.teachers.index')); ?>" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left"></i> Back
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <h6>Qualifications</h6>
                    <p class="text-muted">
                        <?php echo e($teacher->qualifications ?: 'No qualifications provided.'); ?>

                    </p>
                </div>

                <div class="mb-4">
                    <h6>Biography</h6>
                    <p class="text-muted">
                        <?php echo e($teacher->bio ?: 'No biography provided.'); ?>

                    </p>
                </div>

                <!-- Teacher's Courses -->
                <div class="mb-4">
                    <h6>Courses Taught (<?php echo e($teacher->courses->count()); ?>)</h6>
                    <?php if($teacher->courses->count() > 0): ?>
                        <div class="list-group">
                            <?php $__currentLoopData = $teacher->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1"><?php echo e($course->title); ?></h6>
                                        <small class="text-muted">
                                            <?php echo e($course->category->name); ?> • 
                                            <?php echo e($course->level); ?> • 
                                            <?php echo e($course->duration_value); ?> <?php echo e($course->duration_type); ?>

                                        </small>
                                    </div>
                                    <div class="text-end">
                                        <?php if($course->price_type === 'free'): ?>
                                            <span class="badge bg-success">Free</span>
                                        <?php else: ?>
                                            <span class="badge bg-primary">$<?php echo e(number_format($course->price, 2)); ?></span>
                                        <?php endif; ?>
                                        <br>
                                        <small class="text-muted"><?php echo e($course->total_students); ?> students</small>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No courses assigned to this teacher yet.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/teachers/show.blade.php ENDPATH**/ ?>