
<?php $__env->startSection('title', 'Add Testimonial'); ?>
<?php $__env->startSection('page-title', 'Add Testimonial'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus-circle text-success me-2"></i>Add Testimonial</h2>
    <a href="<?php echo e(route('admin.testimonials.index')); ?>" class="btn btn-outline-secondary rounded-pill">Back</a>
  </div>

  <div class="card border-0 rounded-4 shadow-sm">
    <div class="card-body p-4">
      <form action="<?php echo e(route('admin.testimonials.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label fw-semibold">Client Name <span class="text-danger">*</span></label>
            <input type="text" name="client_name" value="<?php echo e(old('client_name')); ?>" class="form-control rounded-3" required>
          </div>
          <div class="col-md-6">
            <label class="form-label fw-semibold">Profession <span class="text-danger">*</span></label>
            <input type="text" name="client_profession" value="<?php echo e(old('client_profession')); ?>" class="form-control rounded-3" required>
          </div>
        </div>

        <div class="mb-3 mt-3">
          <label class="form-label fw-semibold">Review <span class="text-danger">*</span></label>
          <textarea name="review" rows="4" class="form-control rounded-3" required><?php echo e(old('review')); ?></textarea>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Stars <span class="text-danger">*</span></label>
          <select name="stars" class="form-select rounded-3">
            <?php for($i=1;$i<=5;$i++): ?>
              <option value="<?php echo e($i); ?>" <?php echo e(old('stars',5)==$i?'selected':''); ?>><?php echo e($i); ?> Star<?php echo e($i>1?'s':''); ?></option>
            <?php endfor; ?>
          </select>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Image</label>
          <input type="file" name="image" accept="image/*" class="form-control rounded-3">
          <div class="form-text">JPEG, PNG, JPG, GIF ≤ 2 MB</div>
        </div>

        <div class="form-check mb-4">
          <input class="form-check-input" type="checkbox" name="is_active" value="1" checked>
          <label class="form-check-label fw-semibold">Active</label>
        </div>

        <div class="d-flex justify-content-end">
          <button type="submit" class="btn btn-success rounded-pill px-4">Save</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/testimonials/create.blade.php ENDPATH**/ ?>