

<?php $__env->startSection('content'); ?>
<main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
        <div class="container d-lg-flex justify-content-between align-items-center">
            <h1 class="mb-2 mb-lg-0 fw-bold text-dark"><?php echo e($teacher->name); ?></h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                    <li><a href="<?php echo e(route('teacher')); ?>">Instructors</a></li>
                    <li class="current"><?php echo e($teacher->name); ?></li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Teacher Details Section -->
    <section class="teacher-details section">
        <div class="container">
            <div class="row gy-4">
                
                <!-- Teacher Info -->
                <div class="col-lg-4">
                    <div class="teacher-profile-card">
                        <div class="profile-image">
                            <img src="<?php echo e(asset($teacher->profile_image ?? 'assets/images/default-teacher.jpg')); ?>" alt="<?php echo e($teacher->name); ?>" class="img-fluid">
                        </div>
                        <div class="profile-info">
                            <h3><?php echo e($teacher->name); ?></h3>
                            <p class="specialization"><i class="bi bi-person-badge"></i> <?php echo e($teacher->specialization); ?></p>
                            
                            <div class="teacher-stats">
                                <div class="stat-item"><i class="bi bi-clock-history"></i> <?php echo e($teacher->experience_years); ?>+ Years Experience</div>
                                <div class="stat-item"><i class="bi bi-journal-text"></i> <?php echo e($teacher->courses_count); ?> Courses</div>
                            </div>

                            <?php if($teacher->qualifications): ?>
                            <div class="teacher-qualifications">
                                <h5><i class="bi bi-award"></i> Qualifications</h5>
                                <p><?php echo e($teacher->qualifications); ?></p>
                            </div>
                            <?php endif; ?>

                            <div class="social-links">
                                <?php if($teacher->facebook_url): ?>
                                    <a href="<?php echo e($teacher->facebook_url); ?>" target="_blank" class="social-btn facebook"><i class="bi bi-facebook"></i></a>
                                <?php endif; ?>
                                <?php if($teacher->twitter_url): ?>
                                    <a href="<?php echo e($teacher->twitter_url); ?>" target="_blank" class="social-btn twitter"><i class="bi bi-twitter"></i></a>
                                <?php endif; ?>
                                <?php if($teacher->linkedin_url): ?>
                                    <a href="<?php echo e($teacher->linkedin_url); ?>" target="_blank" class="social-btn linkedin"><i class="bi bi-linkedin"></i></a>
                                <?php endif; ?>
                                <?php if($teacher->website_url): ?>
                                    <a href="<?php echo e($teacher->website_url); ?>" target="_blank" class="social-btn globe"><i class="bi bi-globe"></i></a>
                                <?php endif; ?>
                            </div>

                            <div class="contact-info">
                                <?php if($teacher->email): ?>
                                    <div class="contact-item"><i class="bi bi-envelope"></i> <span><?php echo e($teacher->email); ?></span></div>
                                <?php endif; ?>
                                <?php if($teacher->phone): ?>
                                    <div class="contact-item"><i class="bi bi-telephone"></i> <span><?php echo e($teacher->phone); ?></span></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Teacher Content -->
                <div class="col-lg-8">
                    <div class="teacher-bio">
                        <h3 class="mb-3">About Me</h3>
                        <p><?php echo e($teacher->bio); ?></p>
                    </div>

                    <?php if($teacher->courses->count() > 0): ?>
                    <div class="teacher-courses">
                        <h3 class="mb-4">My Courses (<?php echo e($teacher->courses->count()); ?>)</h3>
                        <div class="row">
                            <?php $__currentLoopData = $teacher->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6 mb-4">
                                <div class="course-card">
                                    <div class="course-image">
                                        <img src="<?php echo e(asset($course->image ?? 'assets/images/default-course.jpg')); ?>" alt="<?php echo e($course->title); ?>">
                                    </div>
                                    <div class="course-content">
                                        <h5><?php echo e($course->title); ?></h5>
                                        <p><?php echo e(Str::limit($course->description, 80)); ?></p>
                                        <a href="<?php echo e(route('nadeem', $course->slug)); ?>" class="btn btn-primary btn-sm">View Course</a>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

       <!-- Related Teachers -->
    <?php if($relatedTeachers->count() > 0): ?>
    <section class="related-teachers section bg-light py-5">
        <div class="container">
            <h2 class="section-title text-center mb-5">Other Instructors</h2>
            <div class="row g-4">
                <?php $__currentLoopData = $relatedTeachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedTeacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4">
                    <div class="instructor-card shadow-sm">
                        <div class="instructor-img">
                            <img src="<?php echo e(asset($relatedTeacher->profile_image ?? 'assets/images/default-teacher.jpg')); ?>" alt="<?php echo e($relatedTeacher->name); ?>">
                        </div>
                        <div class="instructor-content">
                            <h4 class="instructor-name"><?php echo e($relatedTeacher->name); ?></h4>
                            <p class="specialization"><?php echo e($relatedTeacher->specialization); ?></p>
                            <div class="instructor-stats">
                                <span><i class="bi bi-clock"></i> <?php echo e($relatedTeacher->experience_years); ?>+ Years</span>
                                <span><i class="bi bi-book"></i> <?php echo e($relatedTeacher->courses_count ?? 0); ?> Courses</span>
                            </div>
                            <a href="<?php echo e(route('teacherdetails', $relatedTeacher->slug)); ?>" class="btn btn-outline-primary mt-3">View Profile</a>
                        </div>

                        <div class="instructor-socials">
                            <?php if($relatedTeacher->facebook_url): ?>
                                <a href="<?php echo e($relatedTeacher->facebook_url); ?>" target="_blank"><i class="bi bi-facebook"></i></a>
                            <?php endif; ?>
                            <?php if($relatedTeacher->twitter_url): ?>
                                <a href="<?php echo e($relatedTeacher->twitter_url); ?>" target="_blank"><i class="bi bi-twitter"></i></a>
                            <?php endif; ?>
                            <?php if($relatedTeacher->linkedin_url): ?>
                                <a href="<?php echo e($relatedTeacher->linkedin_url); ?>" target="_blank"><i class="bi bi-linkedin"></i></a>
                            <?php endif; ?>
                            <?php if($relatedTeacher->website_url): ?>
                                <a href="<?php echo e($relatedTeacher->website_url); ?>" target="_blank"><i class="bi bi-globe"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

</main>

<style>
:root {
    --primary: #28c57a;
    --primary-dark: #1fab69;
    --light-bg: #f9fafb;
    --text-dark: #222;
    --text-muted: #6c757d;
    --border: #e5e7eb;
}

/* ---------- Profile Card ---------- */
.teacher-profile-card {
    background: #fff;
    border-radius: 15px;
    padding: 30px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.08);
    text-align: center;
}
.profile-image {
    width: 180px;
    height: 180px;
    margin: 0 auto 20px;
    border-radius: 50%;
    overflow: hidden;
    border: 5px solid var(--primary);
}
.profile-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.specialization {
    color: var(--primary);
    font-weight: 600;
    font-size: 1rem;
}
.teacher-stats .stat-item {
    color: var(--text-muted);
    font-size: 0.95rem;
    margin: 8px 0;
}
.teacher-qualifications {
    margin-top: 15px;
}
.teacher-qualifications h5 {
    color: var(--primary-dark);
    margin-bottom: 8px;
}
.social-links {
    display: flex;
    justify-content: center;
    gap: 10px;
    margin: 18px 0;
}
.social-btn {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #f1f3f5;
    color: var(--primary);
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
}
.social-btn:hover {
    background: var(--primary);
    color: white;
    transform: translateY(-3px);
}
.contact-item {
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text-muted);
    gap: 8px;
    font-size: 0.95rem;
}

/* ---------- Bio ---------- */
.teacher-bio {
    background: #fff;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.08);
    margin-bottom: 30px;
}

/* ---------- Course Cards ---------- */
.course-card {
    background: white;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 3px 15px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}
.course-card:hover {
    transform: translateY(-5px);
}
.course-image {
    height: 160px;
    overflow: hidden;
}
.course-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.course-content {
    padding: 20px;
}

/* ---------- Other Instructors ---------- */.related-teachers .instructor-card {
    background: #fff;
    border-radius: 16px;
    overflow: hidden;
    text-align: center;
    padding: 25px 20px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
    transition: all 0.3s ease;
    position: relative;
}

.related-teachers .instructor-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.related-teachers .instructor-img {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    overflow: hidden;
    margin: 0 auto 15px;
    border: 4px solid var(--primary);
}

.related-teachers .instructor-img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.related-teachers .instructor-name {
    font-size: 1.2rem;
    font-weight: 700;
    color: #1b1f24;
    margin-bottom: 5px;
}

.related-teachers .specialization {
    color: var(--primary);
    font-weight: 500;
    margin-bottom: 10px;
    font-size: 0.95rem;
}

.related-teachers .instructor-stats {
    display: flex;
    justify-content: center;
    gap: 12px;
    font-size: 0.9rem;
    color: #6c757d;
    margin-bottom: 15px;
}

.related-teachers .instructor-stats i {
    color: var(--primary);
    margin-right: 5px;
}

.related-teachers .btn-outline-primary {
    border-color: var(--primary);
    color: var(--primary);
    font-weight: 600;
    transition: all 0.3s ease;
}

.related-teachers .btn-outline-primary:hover {
    background: var(--primary);
    color: #fff;
}

/* Social links at bottom */
.related-teachers .instructor-socials {
    display: flex;
    justify-content: center;
    gap: 10px;
    margin-top: 20px;
    padding-top: 15px;
    border-top: 1px solid #eee;
}

.related-teachers .instructor-socials a {
    width: 38px;
    height: 38px;
    border-radius: 50%;
    background: #f8f9fa;
    color: var(--primary);
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    font-size: 18px;
}

.related-teachers .instructor-socials a:hover {
    background: var(--primary);
    color: #fff;
    transform: translateY(-3px);
}

</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('apps', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/teacherdetails.blade.php ENDPATH**/ ?>