

<?php $__env->startSection('content'); ?>
<style>
    .post-thumbnail {
        object-fit: cover;
        width: 100%;
        height: 100%;
        max-height: 250px;
        filter: brightness(60%);
        transition: filter 0.3s ease;
    }

    .post-thumbnail:hover {
        filter: brightness(80%);
    }

    .category-badge {
        background-color: #1dbf73;
        color: white;
        font-size: 0.75rem;
        padding: 0.25rem 0.6rem;
        border-radius: 0.25rem;
        position: absolute;
        top: 10px;
        left: 10px;
        z-index: 2;
    }

    .card-hover:hover {
        transform: translateY(-4px);
        transition: all 0.3s ease-in-out;
    }
</style>

<section class="page-title-section bg-dark cover-background theme-overlay">
    <div class="container">
        <div class="row text-center text-white">
            <div class="col-md-12">
                <h2 class="fw-bold mb-0 text-white">
                    Posts tagged with: <span class="text-white"><?php echo e($tag); ?></span>
                </h2>
                <ul class="breadcrumb bg-transparent justify-content-center mt-2">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" class="text-white">Home</a></li> &nbsp;>
                    <li class="breadcrumb-item active text-white">Tag: <?php echo e($tag); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<div class=" p-5 bg-light">
    <?php if($posts->count()): ?>
        <div class="row g-4">
            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-12 col-md-12">
                    <div class="card border-0 shadow-sm card-hover h-100 overflow-hidden">
                        <div class="row g-0 h-100 flex-column flex-md-row">
                            <!-- Image -->
                            <div class="col-md-5 position-relative">
                                <span class="category-badge">
                                    <?php echo e($post->category->name); ?>

                                </span>
                                <img src="<?php echo e(asset('blogs/' . $post->image)); ?>" alt="<?php echo e($post->title); ?>"
                                     class="post-thumbnail rounded-start w-100 h-100">
                            </div>
                            <!-- Content -->
                            <div class="col-md-7 d-flex flex-column">
                                <div class="card-body d-flex flex-column h-100 bg-white">
                                    <a href="<?php echo e(route('details', $post->slug)); ?>" class="text-decoration-none text-dark">
                                        <h5 class="card-title fw-bold"><?php echo e($post->title); ?></h5>
                                    </a>
                                    <p class="card-text small text-muted mb-3"><?php echo e($post->short_description); ?></p>
                                    <div class="mt-auto">
                                        <div class="d-flex align-items-center text-muted small mb-2" ><span style="margin-right: 3px;">Posted On :</span>
                                            <i class="fas fa-calendar me-1" style="margin-right: 3px;"></i>
                                             <span><?php echo e($post->created_at->format('M d, Y')); ?></span>
                                        </div>
                                        <div class="d-flex flex-wrap gap-1">
                                            <?php $__currentLoopData = explode(',', $post->tags); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tagItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(route('posts', trim($tagItem))); ?>"
                                                   class="badge text-white"
                                                   style="background-color: #1dbf73;">
                                                    <?php echo e(trim($tagItem)); ?>

                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End Content -->
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="alert alert-warning mt-4">
            No posts found for this tag.
        </div>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('apps', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/posts-by-tag.blade.php ENDPATH**/ ?>