

<?php $__env->startSection('content'); ?>
<main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">Courses</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
            <li class="current">Courses</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Courses 2 Section -->
    <section id="courses-2" class="courses-2 section">

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row">
          <div class="col-lg-3">
            <div class="course-filters" data-aos="fade-right" data-aos-delay="100">
              <h4 class="filter-title">Filter Courses</h4>

              <form id="filterForm" method="GET" action="<?php echo e(route('courses-quran')); ?>">
                <div class="filter-group">
                  <h5>Category</h5>
                  <div class="filter-options">
                    <label class="filter-checkbox">
                      <input type="radio" name="category" value="" <?php echo e(!request('category') ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      All Categories
                    </label>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="filter-checkbox">
                      <input type="radio" name="category" value="<?php echo e($category->id); ?>" <?php echo e(request('category') == $category->id ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      <?php echo e($category->name); ?>

                    </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>

                <div class="filter-group">
                  <h5>Level</h5>
                  <div class="filter-options">
                    <label class="filter-checkbox">
                      <input type="radio" name="level" value="" <?php echo e(!request('level') ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      All Levels
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="level" value="beginner" <?php echo e(request('level') == 'beginner' ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Beginner
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="level" value="intermediate" <?php echo e(request('level') == 'intermediate' ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Intermediate
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="level" value="advanced" <?php echo e(request('level') == 'advanced' ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Advanced
                    </label>
                  </div>
                </div>
<div class="filter-group">
  <h5>Duration</h5>
  <div class="filter-options">
    <label class="filter-checkbox">
      <input type="radio" name="duration" value="" <?php echo e(!request('duration') ? 'checked' : ''); ?> onchange="this.form.submit()">
      <span class="checkmark"></span>
      All Durations
    </label>

    <label class="filter-checkbox">
      <input type="radio" name="duration" value="hours" <?php echo e(request('duration') == 'hours' ? 'checked' : ''); ?> onchange="this.form.submit()">
      <span class="checkmark"></span>
      Hours
    </label>

    <label class="filter-checkbox">
      <input type="radio" name="duration" value="days" <?php echo e(request('duration') == 'days' ? 'checked' : ''); ?> onchange="this.form.submit()">
      <span class="checkmark"></span>
      Days
    </label>

    <label class="filter-checkbox">
      <input type="radio" name="duration" value="weeks" <?php echo e(request('duration') == 'weeks' ? 'checked' : ''); ?> onchange="this.form.submit()">
      <span class="checkmark"></span>
      Weeks
    </label>

    <label class="filter-checkbox">
      <input type="radio" name="duration" value="months" <?php echo e(request('duration') == 'months' ? 'checked' : ''); ?> onchange="this.form.submit()">
      <span class="checkmark"></span>
      Months
    </label>
  </div>
</div>



                <div class="filter-group">
                  <h5>Price</h5>
                  <div class="filter-options">
                    <label class="filter-checkbox">
                      <input type="radio" name="price_type" value="" <?php echo e(!request('price_type') ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      All Prices
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="price_type" value="free" <?php echo e(request('price_type') == 'free' ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Free
                    </label>
                    <label class="filter-checkbox">
                      <input type="radio" name="price_type" value="paid" <?php echo e(request('price_type') == 'paid' ? 'checked' : ''); ?> onchange="this.form.submit()">
                      <span class="checkmark"></span>
                      Paid
                    </label>
                  </div>
                </div>

                <!-- Hidden fields to preserve other filters -->
                <input type="hidden" name="search" value="<?php echo e(request('search')); ?>">
                <input type="hidden" name="sort" value="<?php echo e(request('sort')); ?>">
              </form>
            </div><!-- End Course Filters -->
          </div>

          <div class="col-lg-9">
            <div class="courses-header" data-aos="fade-left" data-aos-delay="100">
              <form method="GET" action="<?php echo e(route('courses-quran')); ?>" class="d-flex align-items-center gap-3">
                <div class="search-box">
                  <i class="bi bi-search"></i>
                  <input type="text" name="search" placeholder="Search courses..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="sort-dropdown">
            <select name="sort" onchange="this.form.submit()">
  <option value="newest" <?php echo e(request('sort') == 'newest' ? 'selected' : ''); ?>>Sort by: Newest First</option>
  <option value="popular" <?php echo e(request('sort') == 'popular' ? 'selected' : ''); ?>>Most Popular</option>
  <option value="price_low" <?php echo e(request('sort') == 'price_low' ? 'selected' : ''); ?>>Price: Low to High</option>
  <option value="price_high" <?php echo e(request('sort') == 'price_high' ? 'selected' : ''); ?>>Price: High to Low</option>
  <option value="duration" <?php echo e(request('sort') == 'duration' ? 'selected' : ''); ?>>Duration: Short to Long</option>
</select>

                </div>
                
                <!-- Hidden fields to preserve filters -->
                <input type="hidden" name="category" value="<?php echo e(request('category')); ?>">
                <input type="hidden" name="level" value="<?php echo e(request('level')); ?>">
                <input type="hidden" name="duration" value="<?php echo e(request('duration')); ?>">
                <input type="hidden" name="price_type" value="<?php echo e(request('price_type')); ?>">
              </form>
            </div>

 <div class="courses-grid" data-aos="fade-up" data-aos-delay="200">
              <div class="row">
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class="col-lg-6 col-md-6 mb-4">
                  <a href="<?php echo e(route('nadeem', $course->slug)); ?>">
                  <div class="course-card">
                    <div class="course-image">
                      <?php if($course->image): ?>
                        <img src="<?php echo e(asset($course->image)); ?>" alt="<?php echo e($course->title); ?>" class="img-fluid">
                      <?php else: ?>
                        <img src="<?php echo e(asset('assets/img/education/courses-3.webp')); ?>" alt="<?php echo e($course->title); ?>" class="img-fluid">
                      <?php endif; ?>
                      
                      <!-- Course Badges -->
                      <?php if($course->label): ?>
                        <div class="course-badge badge-<?php echo e($course->label); ?>">
                         <i class="fas fa-crown "></i> <?php echo e(ucfirst($course->label)); ?>

                        </div>
                      <?php endif; ?>
                      
                  
                      <!-- Price -->
                      <div class="course-price">
                        <?php if($course->price_type === 'free'): ?>
                          <i class="fas fa-gift"></i> Free
                        <?php else: ?>
                          $<?php echo e(number_format($course->price, 2)); ?>

                        <?php endif; ?>
                      </div>
                    </div>
                    
                    <div class="course-content">
                      <div class="course-meta">
                        <span class="category text-dark"><i class="fas fa-tags"></i> <?php echo e($course->category->name); ?></span>
                        <span class="level level-<?php echo e($course->level); ?>"><i class="fas fa-layer-group"></i> <?php echo e(ucfirst($course->level)); ?></span>
                            <?php if($course->has_certificate): ?>
                        <span class="category text-dark"><i class="fas fa-award"></i> Certificate</span>
                      <?php endif; ?>

                      </div>
                      <h3><?php echo e($course->title); ?></h3>
                      <p><?php echo e(Str::limit($course->description, 120)); ?></p>
                      
                      <div class="course-stats">
                        <div class="stat">
                          <i class="bi bi-clock"></i>
                          <span><?php echo e($course->duration_value); ?> <?php echo e($course->duration_type); ?></span>
                        </div>
                        <div class="stat">
                          <i class="bi bi-people"></i>
                          <span><?php echo e($course->total_students); ?> students</span>
                        </div>
                        <div class="rating">
                          <?php
                            $fullStars = floor($course->ratings);
                            $halfStar = ($course->ratings - $fullStars) >= 0.5;
                            $emptyStars = 5 - $fullStars - ($halfStar ? 1 : 0);
                          ?>
                          
                          <?php for($i = 0; $i < $fullStars; $i++): ?>
                            <i class="bi bi-star-fill"></i>
                          <?php endfor; ?>
                          
                          <?php if($halfStar): ?>
                            <i class="bi bi-star-half"></i>
                          <?php endif; ?>
                          
                          <?php for($i = 0; $i < $emptyStars; $i++): ?>
                            <i class="bi bi-star"></i>
                          <?php endfor; ?>
                          
                          <span><?php echo e(number_format($course->ratings, 1)); ?> (<?php echo e($course->total_students); ?> reviews)</span>
                        </div>
                      </div>
                      
                      <div class="instructor-info">
                        <?php if($course->teacher->profile_image): ?>
                          <img src="<?php echo e(asset($course->teacher->profile_image)); ?>" alt="<?php echo e($course->teacher->name); ?>" class="instructor-avatar">
                        <?php else: ?>
                          <img src="<?php echo e(asset('assets/img/person/person-m-3.webp')); ?>" alt="<?php echo e($course->teacher->name); ?>" class="instructor-avatar">
                        <?php endif; ?>
                        <span class="instructor-name"><?php echo e($course->teacher->name); ?></span>
                      </div>
                      
                   


<a href="<?php echo e(route('enrollment.form', $course->slug)); ?>" class="">
    <?php if($course->price_type === 'free'): ?>
    <button class="btn btn-primary w-100"> <i class="fas fa-gift"></i> Start Free Course</button>
    <?php else: ?>
       <button class="btn btn-success w-100"><i class="fas fa-rocket"></i> Enroll Now</button>
    <?php endif; ?>
</a>

                    </div>
                  </div><!-- End Course Card -->
                                     </a>

                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php if($courses->count() == 0): ?>
                <div class="col-12 text-center py-5">
                  <h4>No courses found</h4>
                  <p class="text-muted">Try adjusting your search or filters</p>
                </div>
                <?php endif; ?>
              </div>
            </div><!-- End Courses Grid -->
       

            <!-- Pagination -->
            <?php if($courses->hasPages()): ?>
            <div class="pagination-wrapper" data-aos="fade-up" data-aos-delay="300">
              <nav aria-label="Courses pagination">
                <ul class="pagination justify-content-center">
                  <?php echo e($courses->appends(request()->query())->links()); ?>

                </ul>
              </nav>
            </div><!-- End Pagination -->
            <?php endif; ?>

          </div>
        </div>

      </div>

    </section><!-- /Courses 2 Section -->

  </main>

  <?php echo $__env->make('footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

  <style>
    .search-box {
      position: relative;
      flex: 1;
    }
    
    .search-box i {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #6c757d;
    }
    
    .search-box input {
      padding-left: 45px;
      width: 100%;
      border: 1px solid #dee2e6;
      border-radius: 8px;
      height: 45px;
    }
    
    .sort-dropdown select {
      border: 1px solid #dee2e6;
      border-radius: 8px;
      height: 45px;
      padding: 0 15px;
    }
    
    .courses-header {
      display: flex;
      gap: 20px;
      margin-bottom: 30px;
      align-items: center;
    }
    
    .filter-checkbox {
      display: block;
      margin-bottom: 10px;
      cursor: pointer;
    }
    
    .course-badge {
      position: absolute;
      top: 15px;
      left: 15px;
      background: #28a745;
      color: white;
      padding: 5px 10px;
      border-radius: 4px;
      font-size: 0.8rem;
      font-weight: 500;
    }
    
    .badge-new { background: #dc3545; }
    .badge-popular { background: #ffc107; color: #000; }
    .badge-featured { background: #17a2b8; }
    .badge-free { background: #28a745; }
    .badge-certificate { background: #6f42c1; }
    
    .course-price {
      position: absolute;
      top: 15px;
      right: 15px;
      background: rgba(0,0,0,0.8);
      color: white;
      padding: 5px 10px;
      border-radius: 4px;
      font-weight: 600;
    }
    
    .level-beginner { background: #28a745; color: white; }
    .level-intermediate { background: #ffc107; color: #000; }
    .level-advanced { background: #dc3545; color: white; }
  </style>

  <script>
    // Auto submit search on enter
    document.querySelector('input[name="search"]').addEventListener('keypress', function(e) {
      if (e.key === 'Enter') {
        this.form.submit();
      }
    });
    
    // Clear filters
    function clearFilters() {
      window.location.href = "<?php echo e(route('courses-quran')); ?>";
    }
  </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('apps', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/courses-quran.blade.php ENDPATH**/ ?>