

<?php $__env->startSection('title', 'Enrollments Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="fw-bold text-dark">
            <i class="fas fa-user-graduate me-2 text-primary"></i> Course Enrollments
        </h1>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-primary">
            <i class="fas fa-home"></i> Dashboard
        </a>
    </div>

    <!-- Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card shadow-sm border-0 bg-gradient-primary text-white h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                    <div>
                        <h4 class="fw-bold mb-0"><?php echo e($enrollments->count()); ?></h4>
                        <small>Total Enrollments</small>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card shadow-sm border-0 bg-gradient-success text-white h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-check-circle fa-2x"></i>
                    </div>
                    <div>
                        <h4 class="fw-bold mb-0"><?php echo e($enrollments->where('status', 'confirmed')->count()); ?></h4>
                        <small>Confirmed</small>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card shadow-sm border-0 bg-gradient-warning text-white h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-hourglass-half fa-2x"></i>
                    </div>
                    <div>
                        <h4 class="fw-bold mb-0"><?php echo e($enrollments->where('status', 'pending')->count()); ?></h4>
                        <small>Pending</small>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card shadow-sm border-0 bg-gradient-info text-white h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-calendar-week fa-2x"></i>
                    </div>
                    <div>
                        <h4 class="fw-bold mb-0"><?php echo e($enrollments->where('created_at', '>=', now()->subDays(7))->count()); ?></h4>
                        <small>This Week</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Enrollments Table -->
    <div class="card shadow-lg border-0">
        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-list me-2"></i> Recent Enrollments</h5>
            <span class="badge bg-light text-dark px-3 py-2">
                <i class="fas fa-bell me-1 text-warning"></i> <?php echo e($enrollments->where('status', 'pending')->count()); ?> new pending
            </span>
        </div>
        <div class="card-body bg-light">
            <?php if($enrollments->isEmpty()): ?>
                <div class="text-center py-5">
                    <i class="fas fa-user-slash fa-3x text-muted"></i>
                    <h4 class="text-muted mt-3">No Enrollments Found</h4>
                    <p class="text-muted">Once students enroll, their details will appear here.</p>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-dark text-white">
                            <tr>
                                <th><i class="fas fa-hashtag me-1"></i> Code</th>
                                <th><i class="fas fa-user me-1"></i> Student</th>
                                <th><i class="fas fa-book me-1"></i> Course</th>
                                <th><i class="fas fa-envelope me-1"></i> Contact</th>
                                <th><i class="fas fa-calendar-alt me-1"></i> Date</th>
                                <th><i class="fas fa-info-circle me-1"></i> Status</th>
                                <th><i class="fas fa-cogs me-1"></i> Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="fw-bold text-primary"><?php echo e($enrollment->enrollment_code); ?></td>
                                <td>
                                    <strong><?php echo e($enrollment->first_name); ?> <?php echo e($enrollment->last_name); ?></strong><br>
                                    <small class="text-muted"><?php echo e($enrollment->education_level ?? 'N/A'); ?></small>
                                </td>
                                <td>
                                    <strong><?php echo e($enrollment->course->title); ?></strong><br>
                                    <small class="text-muted">
                                        <?php echo e(ucfirst($enrollment->course->level)); ?> • <?php echo e($enrollment->course->duration_value); ?> <?php echo e($enrollment->course->duration_type); ?>

                                    </small>
                                </td>
                                <td>
                                    <i class="fas fa-envelope text-muted"></i> <?php echo e($enrollment->email); ?><br>
                                    <i class="fas fa-phone text-muted"></i> <small><?php echo e($enrollment->phone); ?></small>
                                </td>
                                <td>
                                    <span class="fw-semibold"><?php echo e($enrollment->created_at->format('M d, Y')); ?></span><br>
                                    <small class="text-muted"><i class="fas fa-clock"></i> <?php echo e($enrollment->created_at->format('h:i A')); ?></small>
                                </td>
                                <td>
                                    <?php if($enrollment->status == 'pending'): ?>
                                        <span class="badge bg-warning text-dark"><i class="fas fa-clock"></i> Pending</span>
                                    <?php elseif($enrollment->status == 'confirmed'): ?>
                                        <span class="badge bg-success"><i class="fas fa-check-circle"></i> Confirmed</span>
                                    <?php elseif($enrollment->status == 'completed'): ?>
                                        <span class="badge bg-info text-dark"><i class="fas fa-flag-checkered"></i> Completed</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger"><i class="fas fa-times-circle"></i> Cancelled</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('admin.enrollments.show', $enrollment->id)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.enrollments.edit', $enrollment->id)); ?>" class="btn btn-sm btn-outline-success">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.bg-gradient-primary { background: linear-gradient(45deg, #007bff, #00bfff); }
.bg-gradient-success { background: linear-gradient(45deg, #28a745, #20c997); }
.bg-gradient-warning { background: linear-gradient(45deg, #ffc107, #ff9800); }
.bg-gradient-info { background: linear-gradient(45deg, #17a2b8, #00bcd4); }
.table-hover tbody tr:hover {
    background-color: rgba(0, 123, 255, 0.05);
}
.card { border-radius: 15px; }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/enrollments/index.blade.php ENDPATH**/ ?>