<?php $__env->startSection('title', 'Contact Messages'); ?>
<?php $__env->startSection('page-title', 'Contact Messages'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-envelope me-2"></i>
                    Contact Messages
                </h5>
            </div>
            <div class="card-body">
                <?php if($contacts->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Subject</th>
                                    <th>Message</th>
                                    <th>Status</th>
                                    <th>Received At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="<?php echo e(!$contact->is_read ? 'table-warning' : ''); ?>">
                                    <td><?php echo e($contact->id); ?></td>
                                    <td>
                                        <?php echo e($contact->name); ?>

                                        <?php if(!$contact->is_read): ?>
                                            <span class="badge bg-primary ms-1">New</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($contact->email); ?></td>
                                    <td><?php echo e(Str::limit($contact->subject, 30) ?: 'No Subject'); ?></td>
                                    <td><?php echo e(Str::limit($contact->message, 50)); ?></td>
                                    <td>
                                        <?php if($contact->is_read): ?>
                                            <span class="badge bg-success">Read</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning">Unread</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($contact->created_at->format('M d, Y h:i A')); ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.contacts.show', $contact)); ?>" class="btn btn-sm btn-outline-dark">
                                                <i class="fas fa-eye"></i>
                                            </a>&nbsp;
                                            <form action="<?php echo e(route('admin.contacts.destroy', $contact)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this message?')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-center">
                        <?php echo e($contacts->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-envelope fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No contact messages</h5>
                        <p class="text-muted">Contact messages from your website will appear here.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/contacts/index.blade.php ENDPATH**/ ?>