<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Enrollment Confirmation</title>
</head>
<body style="font-family: 'Inter', Arial, sans-serif; margin: 0; padding: 0; background: #f5f6fa;">

  <!-- Email Container -->
  <div style="max-width: 650px; margin: 40px auto; background: #fff; border-radius: 20px; overflow: hidden; box-shadow: 0 10px 40px rgba(0,0,0,0.1); position: relative;">

 
    <!-- Header -->
    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white; text-align: center; padding: 40px 25px; position: relative; z-index: 1;">
        <?php if($setting->logo): ?>
        <div style="text-align: center; margin-bottom: 20px;">
          <img src="cid:logo.png" alt="Logo"
               style="width: 180px; height: auto; display: block; margin: 0 auto; background: white; border-radius: 10px; padding: 10px;">
        </div>
        <?php endif; ?>

        <div style="font-size: 1.8rem; font-weight: 700;"><?php echo e($setting->site_name); ?></div>
        <h1 style="margin: 15px 0 5px; font-size: 2.3rem;">🎓 Welcome Aboard!</h1>
        <p style="margin: 0; font-size: 1.1rem; opacity: 0.9;">Your learning journey begins now</p>
    </div>

    <!-- Body -->
    <div style="padding: 40px 30px; position: relative; z-index: 1;">

      <div style="text-align: center; margin-bottom: 25px;">
        <div style="font-size: 3rem;">🚀</div>
        <h2 style="margin: 10px 0; color: #333;">Hello <?php echo e($enrollment->first_name); ?>!</h2>
        <p style="font-size: 1.05rem; color: #555;">
          Thank you for enrolling in our course. We're thrilled to have you on board!
        </p>
      </div>

      <!-- Course Card -->
      <div style="background: #f8f9fa; border-radius: 15px; padding: 25px; margin: 25px 0;
                  border-left: 5px solid #667eea;">
        <h3 style="margin-top: 0; color: #667eea;"><?php echo e($enrollment->course->title); ?></h3>
        <table width="100%" cellpadding="0" cellspacing="0" style="font-size: 14px;">
          <tr>
            <td><strong>Level:</strong></td>
            <td><?php echo e(ucfirst($enrollment->course->level)); ?></td>
          </tr>
          <tr>
            <td><strong>Duration:</strong></td>
            <td><?php echo e($enrollment->course->duration_value); ?> <?php echo e($enrollment->course->duration_type); ?></td>
          </tr>
          <tr>
            <td><strong>Price Type:</strong></td>
            <td><?php echo e(ucfirst($enrollment->course->price_type)); ?></td>
          </tr>
            <tr>
            <td><strong>Price:</strong></td>
            <td><?php echo e(ucfirst($enrollment->course->price)); ?></td>
          </tr>
          <?php if($enrollment->course->has_certificate): ?>
          <tr>
            <td><strong>Certificate:</strong></td>
            <td>🎓 Included upon completion</td>
          </tr>
          <?php endif; ?>
        </table>
      </div>

      <!-- Enrollment Details -->
      <div style="background: #eef2ff; border-radius: 15px; padding: 25px; margin: 25px 0;">
        <h4 style="color: #495057;">Enrollment Details</h4>
        <table width="100%" cellpadding="0" cellspacing="0" style="font-size: 14px;">
          <tr>
            <td><strong>Enrollment Code:</strong></td>
            <td><?php echo e($enrollment->enrollment_code); ?></td>
          </tr>
          <tr>
            <td><strong>Student Name:</strong></td>
            <td><?php echo e($enrollment->first_name); ?> <?php echo e($enrollment->last_name); ?></td>
          </tr>
          <tr>
            <td><strong>Email:</strong></td>
            <td><?php echo e($enrollment->email); ?></td>
          </tr>
          <tr>
            <td><strong>Phone:</strong></td>
            <td><?php echo e($enrollment->phone); ?></td>
          </tr>
          <tr>
            <td><strong>Schedule:</strong></td>
            <td><?php echo e(ucfirst($enrollment->preferred_schedule)); ?></td>
          </tr>
          <tr>
            <td><strong>Enrollment Date:</strong></td>
            <td><?php echo e($enrollment->created_at->format('F d, Y \a\t h:i A')); ?></td>
          </tr>
        </table>
      </div>

      <!-- Next Steps -->
      <div style="background: #e8f5e8; border-radius: 15px; padding: 25px;">
        <h4 style="color: #28a745;">Next Steps</h4>
        <ol style="padding-left: 20px; color: #495057; font-size: 14px;">
          <li><strong>Check Your Email:</strong> You’ll receive course access within 24 hours.</li>
          <li><strong>Setup Your Learning Environment:</strong> Ensure a stable internet connection.</li>
          <li><strong>Join Our Community:</strong> Connect with peers on our learning platform.</li>
        </ol>
      </div>

      <div style="text-align: center; margin-top: 25px;">
        <p><strong>Need Help?</strong><br>
          📧 <?php echo e($setting->site_email); ?> &nbsp; | &nbsp; 📞 <?php echo e($setting->site_phone); ?>

        </p>
      </div>

    </div>

    <!-- Footer -->
    <div style="background: #f8f9fa; padding: 30px; text-align: center; color: #6c757d; font-size: 14px; border-top: 1px solid #e9ecef;">
      <p style="margin: 0 0 10px;">&copy; <?php echo e(date('Y')); ?> <?php echo e($setting->site_name); ?>. All rights reserved.</p>
      <div style="margin: 10px 0;">
        <a href="<?php echo e($setting->facebook_url); ?>" style="color: #667eea; margin: 0 8px; text-decoration: none;">Facebook</a> |
        <a href="<?php echo e($setting->youtube_url); ?>" style="color: #667eea; margin: 0 8px; text-decoration: none;">YouTube</a> |
        <a href="<?php echo e($setting->linkedin_url); ?>" style="color: #667eea; margin: 0 8px; text-decoration: none;">LinkedIn</a> |
        <a href="<?php echo e($setting->instagram_url); ?>" style="color: #667eea; margin: 0 8px; text-decoration: none;">Instagram</a>
      </div>
      <p style="opacity: 0.7; margin: 0;">This email was sent to <?php echo e($enrollment->email); ?> because you enrolled in our course.</p>
    </div>
  </div>
</body>
</html>
<?php /**PATH E:\xampp2\htdocs\ayz\resources\views/emails/enrollment/confirmation.blade.php ENDPATH**/ ?>