

<?php $__env->startSection('content'); ?>
 <style >
.badge.featured-badge {
    background-color: #ffc107; /* Gold / yellow */
    color: #000;
    padding: 5px 10px;
    border-radius: 5px;
    font-size: 0.8rem;
    display: inline-block;
}

.category-card {
  transition: all 0.3s ease;
  transform: translateY(0);
}

.category-card:hover {
  transform: translateY(-8px);
  box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.category-card .hover-overlay {
  background: linear-gradient(135deg, rgba(0,123,255,0.08), rgba(0,212,255,0.15));
  opacity: 0;
  transition: opacity 0.3s ease;
}

.category-card:hover .hover-overlay {
  opacity: 1;
}

.category-icon img, 
.category-icon .default-icon {
  transition: all 0.3s ease;
}

.category-card:hover .category-icon img {
  transform: scale(1.1);
}

.category-card:hover h5 {
  color: #0d6efd;
}

.bg-primary-subtle {
  background-color: rgba(13,110,253,0.1);
}

/* Custom CSS for Premium Design */
#testimonials {
  background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
  position: relative;
}

.py-6 {
  padding-top: 6rem !important;
  padding-bottom: 6rem !important;
}

.mt-8 {
  margin-top: 8rem !important;
}

/* Background Blobs */
.blob-shape-1 {
  width: 400px;
  height: 400px;
  background: linear-gradient(135deg, rgba(59, 130, 246, 0.05) 0%, rgba(147, 51, 234, 0.05) 100%);
  border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
  animation: morph 8s ease-in-out infinite;
}

.blob-shape-2 {
  width: 300px;
  height: 300px;
  background: linear-gradient(135deg, rgba(34, 197, 94, 0.05) 0%, rgba(59, 130, 246, 0.05) 100%);
  border-radius: 53% 47% 43% 57% / 51% 39% 61% 49%;
  animation: morph 6s ease-in-out infinite;
}

@keyframes morph {
  0%, 100% { border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%; }
  50% { border-radius: 30% 60% 70% 40% / 50% 60% 30% 60%; }
}

/* Text Gradient */
.text-gradient-primary {
  background: linear-gradient(135deg, #3b82f6, #8b5cf6);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
}

/* Testimonial Card */
.testimonial-card {
  background: white;
  transition: all 0.3s ease;
  position: relative;
  overflow: hidden;
}

.testimonial-card:hover {
  transform: translateY(-8px);
  box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15) !important;
}

.testimonial-card::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 4px;
  height: 100%;
  background: linear-gradient(135deg, #3b82f6, #8b5cf6);
  opacity: 0;
  transition: opacity 0.3s ease;
}

.testimonial-card:hover::before {
  opacity: 1;
}

/* Hover Border Effect */
.hover-border {
  position: absolute;
  inset: 0;
  border-radius: 0.75rem;
  padding: 2px;
  background: linear-gradient(135deg, #3b82f6, #8b5cf6, #06b6d4);
  -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
  mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
  -webkit-mask-composite: xor;
  mask-composite: exclude;
  opacity: 0;
  transition: opacity 0.3s ease;
}

.testimonial-card:hover .hover-border {
  opacity: 1;
}

/* Testimonial Text */
.testimonial-text {
  position: relative;
  line-height: 1.7;
}

/* Client Avatar */
.client-avatar img {
  transition: transform 0.3s ease;
}

.testimonial-card:hover .client-avatar img {
  transform: scale(1.1);
}

.verified-badge {
  width: 20px;
  height: 20px;
}

/* Star Rating */
.star-rating .bi-star-fill {
  animation: pulse 2s infinite;
}

.star-rating .bi-star-fill:nth-child(2) { animation-delay: 0.2s; }
.star-rating .bi-star-fill:nth-child(3) { animation-delay: 0.4s; }
.star-rating .bi-star-fill:nth-child(4) { animation-delay: 0.6s; }
.star-rating .bi-star-fill:nth-child(5) { animation-delay: 0.8s; }

@keyframes pulse {
  0%, 100% { transform: scale(1); }
  50% { transform: scale(1.1); }
}

/* Custom Carousel Controls */
.carousel-controls {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 2rem;
}

.custom-carousel-control {
  position: relative;
  width: auto;
  opacity: 1;
}

.custom-carousel-control .carousel-control-prev-icon,
.custom-carousel-control .carousel-control-next-icon {
  background-size: 1rem;
  width: 60px;
  height: 60px;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}

.custom-carousel-control:hover .carousel-control-prev-icon,
.custom-carousel-control:hover .carousel-control-next-icon {
  transform: scale(1.1);
  box-shadow: 0 10px 25px -5px rgba(59, 130, 246, 0.4);
}

/* Custom Indicators */
.carousel-indicators-custom {
  display: flex;
  gap: 0.5rem;
}

.carousel-indicators-custom button {
  width: 12px;
  height: 12px;
  border-radius: 50%;
  border: none;
  background: #cbd5e1;
  transition: all 0.3s ease;
}

.carousel-indicators-custom button.active {
  background: #3b82f6;
  transform: scale(1.2);
}

.carousel-indicators-custom button:hover {
  background: #94a3b8;
}

/* Stats Section */
.bg-gradient-primary {
  background: linear-gradient(135deg, #3b82f6 0%, #8b5cf6 50%, #06b6d4 100%) !important;
}

.stat-item h3 {
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* Responsive Design */
@media (max-width: 768px) {
  .py-6 {
    padding-top: 4rem !important;
    padding-bottom: 4rem !important;
  }
  
  .carousel-controls {
    gap: 1rem;
  }
  
  .custom-carousel-control .carousel-control-prev-icon,
  .custom-carousel-control .carousel-control-next-icon {
    width: 50px;
    height: 50px;
  }
  
  .testimonial-card .card-body {
    padding: 2rem !important;
  }
}

/* Smooth animations */
[data-aos] {
  transition: all 0.6s ease;
}

 </style>
    <!-- MAIN WRAPPER
    ================================================== -->
    <main class="main">

<!-- Dynamic Hero Section -->
<section id="courses-hero" class="courses-hero section light-background">

  <div class="hero-content">
    <div class="container">
      <div class="row align-items-center">

        <div class="col-lg-6" data-aos="fade-up" data-aos-delay="100">
          <div class="hero-text">
            <h1><?php echo e($homeContents->hero_heading ?? 'Transform Your Future with Expert-Led Online Courses'); ?></h1>
            <p><?php echo e($homeContents->description ?? 'Discover thousands of high-quality courses designed by industry professionals.'); ?></p>

            <div class="hero-stats">
              <div class="stat-item">
                <span class="number purecounter" data-purecounter-start="0" data-purecounter-end="<?php echo e($totalStudents ?? 50000); ?>" data-purecounter-duration="2"></span>
                <span class="label">Students Enrolled</span>
              </div>
              <div class="stat-item">
                <span class="number purecounter" data-purecounter-start="0" data-purecounter-end="<?php echo e($topCourses->count() ?? 3); ?>" data-purecounter-duration="2"></span>
                <span class="label">Available Courses</span>
              </div>
              <div class="stat-item">
                <span class="number purecounter" data-purecounter-start="0" data-purecounter-end="<?php echo e(round($averageSuccessRate ?? 90)); ?>" data-purecounter-duration="2"></span>
                <span class="label">Success Rate %</span>
              </div>
            </div>

            <div class="hero-buttons">
              <a href="<?php echo e($homeContents->button_link); ?>" class="btn btn-primary">
                <?php echo e($homeContents->button_text ?? 'Browse Courses'); ?>

              </a>
       
            </div>

            <div class="hero-features">
              <div class="feature">
                <i class="bi bi-shield-check"></i>
                <span><?php echo e($homeContents->feature_1 ?? 'Certified Programs'); ?></span>
              </div>
              <div class="feature">
                <i class="bi bi-clock"></i>
                <span><?php echo e($homeContents->feature_2 ?? 'Lifetime Access'); ?></span>
              </div>
              <div class="feature">
                <i class="bi bi-people"></i>
                <span><?php echo e($homeContents->feature_3 ?? 'Expert Instructors'); ?></span>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-6" data-aos="fade-up" data-aos-delay="200">
          <div class="hero-image">
            <div class="main-image">
              <img src="<?php echo e(asset('home/' .$homeContents->image ?? 'assets/img/education/courses-13.webp')); ?>" alt="Online Learning" class="img-fluid">
            </div>

          <div class="floating-cards">
    <?php $__currentLoopData = $topCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="course-card" data-aos="fade-up" data-aos-delay="<?php echo e(300 + ($index * 100)); ?>">
            <div class="card-icon">
                <?php if($index == 0): ?>
                    <i class="bi bi-book"></i>
                <?php elseif($index == 1): ?>
                    <i class="bi bi-book"></i>
                <?php else: ?>

                    <i class="bi bi-book"></i>
                <?php endif; ?>
            </div>
            <div class="card-content">
                <h6><?php echo e($course->title); ?></h6>
                <span><?php echo e($course->total_students); ?> Students</span>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

          </div>
        </div>

      </div>
    </div>
  </div>

  <div class="hero-background">
    <div class="bg-shapes">
      <div class="shape shape-1"></div>
      <div class="shape shape-2"></div>
      <div class="shape shape-3"></div>
    </div>
  </div>
</section>
<section id="featured-courses" class="featured-courses section">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2>Featured Courses</h2>
    <p>Explore our top-rated courses designed by expert instructors.</p>
  </div><!-- End Section Title -->

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row gy-4">

      <?php $__currentLoopData = $featuredCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="<?php echo e(200 + ($index * 100)); ?>">
        <div class="course-card">
          <div class="course-image">
            <img src="<?php echo e(asset($course->image)); ?>" alt="<?php echo e($course->title); ?>" class="img-fluid">
            
          
<?php if($course->is_featured): ?>
    <div class="badge featured-badge">
        <i class="fas fa-crown me-1"></i> Featured
    </div>
<?php endif; ?>

            <div class="price-badge">
              <?php if($course->price_type == 'free'): ?> Free 
              <?php else: ?> $<?php echo e(number_format($course->price, 2)); ?> 
              <?php endif; ?>
            </div>
          </div>

          <div class="course-content">
            <div class="course-meta">
              <span class="level"><i class="fas fa-tags"></i> <?php echo e($course->category->name); ?></span>
              <span class="duration"><i class="fas fa-layer-group"></i> <?php echo e(ucfirst($course->level)); ?></span>
                   <?php if($course->has_certificate): ?>
                        <span class="category text-dark duration"><i class="fas fa-award"></i> Certificate</span>
                      <?php endif; ?>
            </div>

            <h3><a href="<?php echo e(route('nadeem', $course->slug)); ?>"><?php echo e($course->title); ?></a></h3>
            <p><?php echo e(Str::limit($course->description, 100)); ?></p>

            <div class="instructor">
              <img src="<?php echo e(asset($course->teacher->profile_image ?? 'default-teacher.jpg')); ?>" alt="<?php echo e($course->teacher->name ?? 'Instructor'); ?>" class="instructor-img">
              <div class="instructor-info">
                <h6><?php echo e($course->teacher->name ?? 'Instructor'); ?></h6>
                <span><?php echo e($course->teacher->specialty ?? ''); ?></span>
              </div>
            </div>

            <div class="course-stats">
              <div class="rating">
                <?php for($i = 1; $i <= 5; $i++): ?>
                  <?php if($course->ratings >= $i): ?>
                    <i class="bi bi-star-fill"></i>
                  <?php elseif($course->ratings > $i-1): ?>
                    <i class="bi bi-star-half"></i>
                  <?php else: ?>
                    <i class="bi bi-star"></i>
                  <?php endif; ?>
                <?php endfor; ?>
                <span>(<?php echo e($course->ratings); ?>)</span>
              </div>
              <div class="students">
                <i class="bi bi-people-fill"></i>
                <span><?php echo e($course->total_students); ?> students</span>
              </div>
            </div>


            <a href="<?php echo e(route('enrollment.form', $course->slug)); ?>" class="">
    <?php if($course->price_type === 'free'): ?>
    <button class="btn btn-primary w-100"> <i class="fas fa-gift"></i> Start Free Course</button>
    <?php else: ?>
       <button class="btn btn-success w-100"><i class="fas fa-rocket"></i> Enroll Now</button>
    <?php endif; ?>
</a>


          </div>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>

    <div class="more-courses text-center" data-aos="fade-up" data-aos-delay="500">
      <a href="<?php echo e(route('courses-quran')); ?>" class="btn-more">View All Courses</a>
    </div>
  </div>

</section>


<!-- categories -->
<!-- Course Categories Section -->
<section id="course-categories" class="course-categories section py-5 bg-light">

  <!-- Section Title -->
  <div class="container text-center mb-5" data-aos="fade-up">
    <h2 class="fw-bold display-6 mb-2">Explore Course Categories</h2>
    <p class="text-muted fs-5">
      Discover diverse Quran and Islamic learning paths tailored for every student.
    </p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row g-4 justify-content-center">

      <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6" 
             data-aos="zoom-in" 
             data-aos-delay="<?php echo e(100 + ($index * 50)); ?>">

          <a href="<?php echo e(route('courses.by.category', $category->slug)); ?>" class="category-card text-center d-block p-4 rounded-4 shadow-sm bg-white position-relative overflow-hidden transition">

            <div class="category-icon mb-3 position-relative mx-auto d-flex align-items-center justify-content-center">
              <?php if($category->icon): ?>
                <img src="<?php echo e(asset($category->icon)); ?>" width="70" height="70"
                     class="rounded-circle border border-3 border-primary shadow-sm" 
                     style="object-fit: cover;" 
                     alt="<?php echo e($category->name); ?>">
              <?php else: ?>
                <div class="default-icon d-flex align-items-center justify-content-center rounded-circle border border-2 border-primary bg-primary-subtle" style="width:70px;height:70px;">
                  <i class="bi bi-book fs-3 text-primary"></i>
                </div>
              <?php endif; ?>
            </div>

            <h5 class="fw-semibold mb-1 text-dark"><?php echo e($category->name); ?></h5>
            <span class="course-count small text-muted d-block">
              <?php echo e($category->courses_count); ?> <?php echo e(Str::plural('Course', $category->courses_count)); ?>

            </span>

            <div class="hover-overlay position-absolute top-0 start-0 w-100 h-100 rounded-4"></div>

          </a>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>
  </div>
</section>

<!-- teachers -->
 <!-- Featured Instructors Section -->
<section id="featured-instructors" class="featured-instructors section">
  <div class="container section-title" data-aos="fade-up">
    <h2>Featured Instructors</h2>
    <p>Meet our qualified Quran and Islamic Studies teachers</p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row gy-4">

      <?php $__empty_1 = true; $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <div class="col-xl-3 col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="<?php echo e($loop->iteration * 100); ?>">
        <div class="instructor-card">
          <div class="instructor-image">
            <img src="<?php echo e(asset($teacher->profile_image)); ?>" class="img-fluid" alt="<?php echo e($teacher->name); ?>">
            <div class="overlay-content">
              <div class="rating-stars">
                <?php for($i = 1; $i <= 5; $i++): ?>
                  <?php if($i <= 4): ?>
                    <i class="bi bi-star-fill"></i>
                  <?php else: ?>
                    <i class="bi bi-star-half"></i>
                  <?php endif; ?>
                <?php endfor; ?>
                <span>4.9</span>
              </div>
              <div class="course-count">
                <i class="bi bi-play-circle"></i>
                <span><?php echo e($teacher->courses_count); ?> Courses</span>
              </div>
            </div>
          </div>

          <div class="instructor-info">
            <h5><?php echo e($teacher->name); ?></h5>
            <p class="specialty"><i class="fas fa-user-graduate"></i> <?php echo e($teacher->specialization); ?></p>
            <p class="description"><?php echo e(Str::limit($teacher->bio, 100)); ?></p>

            <div class="stats-grid">
              <div class="stat">
                <span class="number"><?php echo e($teacher->courses_count * 50); ?></span>
                <span class="label">Students</span>
              </div>
              <div class="stat">
                <span class="number"><?php echo e($teacher->experience_years); ?>+</span>
                <span class="label">Experience</span>
              </div>
            </div>

            <div class="action-buttons">
              <a href="<?php echo e(route('teacherdetails', $teacher->slug)); ?>" class="btn-view w-100 text-center">View Profile</a>
             <!--  <div class="social-links">
                <?php if($teacher->facebook_url): ?>
                  <a href="<?php echo e($teacher->facebook_url); ?>"><i class="bi bi-facebook"></i></a>
                <?php endif; ?>
                <?php if($teacher->twitter_url): ?>
                  <a href="<?php echo e($teacher->twitter_url); ?>"><i class="bi bi-twitter"></i></a>
                <?php endif; ?>
                <?php if($teacher->linkedin_url): ?>
                  <a href="<?php echo e($teacher->linkedin_url); ?>"><i class="bi bi-linkedin"></i></a>
                <?php endif; ?>
              </div> -->
            </div>
          </div>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
      <p class="text-center">No featured instructors found.</p>
      <?php endif; ?>

    </div>
  </div>
</section>



<!-- testimonials -->

<section id="testimonials" class="py-6 position-relative overflow-hidden">
  <!-- Background Elements -->
  <div class="position-absolute top-0 start-0 w-100 h-100">
    <div class="position-absolute top-0 end-0">
      <div class="blob-shape-1"></div>
    </div>
    <div class="position-absolute bottom-0 start-0">
      <div class="blob-shape-2"></div>
    </div>
  </div>

  <div class="container position-relative">
    <!-- Section Header -->
    <div class="text-center mb-6" data-aos="fade-up">
      <span class="badge bg-primary-soft text-primary rounded-pill px-3 py-2 mb-3 d-inline-flex align-items-center">
        <i class="bi bi-chat-quote-fill me-2"></i>
        Testimonials
      </span>
      <h2 class="display-5 fw-bold text-dark mb-3">Voices of <span class="text-gradient-primary">Success</span></h2>
      <p class="lead text-muted mx-auto" style="max-width: 600px;">
        Discover how our courses are transforming careers and changing lives across the globe
      </p>
    </div>

    <!-- Testimonials Carousel -->
    <div class="testimonial-carousel-wrapper">
      <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000">
        <div class="carousel-inner">
          <?php $__currentLoopData = $testimonials->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunkIndex => $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="carousel-item <?php echo e($chunkIndex == 0 ? 'active' : ''); ?>">
              <div class="row g-4 justify-content-center">
                <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="col-lg-6" data-aos="fade-up" data-aos-delay="<?php echo e($loop->index * 100); ?>">
                    <div class="testimonial-card card border-0 shadow-sm h-100 rounded-4">
                      <div class="card-body p-5">
                        <!-- Quote Icon -->
                        <div class="quote-icon mb-4">
                          <i class="bi bi-quote text-primary opacity-25" style="font-size: 3rem;"></i>
                        </div>
                        
                        <!-- Review Text -->
                        <p class="testimonial-text fs-5 text-dark mb-4 lh-base">
                          "<?php echo e($testimonial->review); ?>"
                        </p>

                        <!-- Client Info -->
                        <div class="d-flex align-items-center">
                          <div class="client-avatar position-relative me-4">
                            <img src="<?php echo e(asset($testimonial->image)); ?>" 
                                 onerror="this.src='https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=100&h=100&fit=crop&crop=face&auto=format'" 
                                 class="rounded-circle shadow" 
                                 width="70" height="70" 
                                 alt="<?php echo e($testimonial->client_name); ?>">
                            <div class="verified-badge position-absolute bottom-0 end-0 bg-success rounded-circle p-1 border border-3 border-white">
                              <i class="bi bi-check-lg text-white" style="font-size: 0.7rem;"></i>
                            </div>
                          </div>
                          
                          <div class="flex-grow-1">
                            <h5 class="fw-bold text-dark mb-1"><?php echo e($testimonial->client_name); ?></h5>
                            <p class="text-muted mb-2"><?php echo e($testimonial->client_profession); ?></p>
                            
                            <!-- Star Ratings -->
                            <div class="star-rating">
                              <?php for($i = 1; $i <= 5; $i++): ?>
                                <i class="bi <?php echo e($i <= $testimonial->stars ? 'bi-star-fill text-warning' : 'bi-star text-muted'); ?> small"></i>
                              <?php endfor; ?>
                              <span class="text-muted small ms-2"><?php echo e($testimonial->stars); ?>.0</span>
                            </div>
                          </div>
                          
                          <!-- Company Logo (Optional) -->
                          <div class="company-logo ms-3">
                            <div class="bg-light rounded-3 p-2">
                              <i class="bi bi-building text-primary fs-4"></i>
                            </div>
                          </div>
                        </div>
                      </div>
                      
                      <!-- Hover Effect Border -->
                      <div class="hover-border"></div>
                    </div>
                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Custom Controls -->
        <div class="carousel-controls mt-5">
          <button class="carousel-control-prev custom-carousel-control" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon bg-primary rounded-circle p-3 shadow">
              <i class="bi bi-chevron-left text-white"></i>
            </span>
          </button>
          
          <!-- Indicators -->
          <div class="carousel-indicators-custom">
            <?php $__currentLoopData = $testimonials->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunkIndex => $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <button type="button" data-bs-target="#testimonialCarousel" 
                      data-bs-slide-to="<?php echo e($chunkIndex); ?>" 
                      class="<?php echo e($chunkIndex == 0 ? 'active' : ''); ?>"
                      aria-label="Slide <?php echo e($chunkIndex + 1); ?>">
              </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
          
          <button class="carousel-control-next custom-carousel-control" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
            <span class="carousel-control-next-icon bg-primary rounded-circle p-3 shadow">
              <i class="bi bi-chevron-right text-white"></i>
            </span>
          </button>
        </div>
      </div>
    </div>

  </div>
</section>





<!-- blogs -->
<!-- Recent Blog Posts Section -->
<section id="recent-blog-posts" class="recent-blog-posts section">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2>Recent Blog Posts</h2>
    <p>Latest insights and Islamic learnings from our Quran Academy</p>
  </div><!-- End Section Title -->

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row gy-4">

      <?php $__currentLoopData = $latestBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-4" data-aos="fade-up" data-aos-delay="<?php echo e(200 + ($index * 100)); ?>">
          <div class="card border-0 shadow-md rounded-4 overflow-hidden h-100">
            
            <!-- Card Top -->
            <div class="card-top d-flex align-items-center p-3">
           
                   <i class="fas fa-user-circle rounded-circle me-2 text-success" style="font-size: 30px;"></i>
              <span class="author-name text-muted small">By <?php echo e($blog->author ?? 'Admin'); ?></span>
              <span class="ms-auto likes text-success">
              </span>
            </div>

            <!-- Card Image -->
            <div class="card-img-wrapper">
              <img src="<?php echo e(asset('blogs/'.$blog->image)); ?>" 
                   alt="<?php echo e($blog->title); ?>" 
                   class="img-fluid w-100">
            </div>

            <!-- Card Body -->
            <div class="card-body">
              <h5 class="card-title">
                <a href="<?php echo e(route('details', $blog->slug)); ?>" class="text-decoration-none text-dark">
                  <?php echo e(Str::limit($blog->title, 60)); ?>

                </a>
              </h5>
              <p class="card-text text-muted">
                <?php echo e(Str::limit($blog->short_description, 120)); ?>

              </p>
            </div>

          </div>
        </div><!-- End Post Item Card -->
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

      <?php if($latestBlogs->isEmpty()): ?>
        <div class="col-12 text-center">
          <p>No blog posts available yet.</p>
        </div>
      <?php endif; ?>

    </div><!-- End Row -->
  </div><!-- End Container -->

</section><!-- /Recent Blog Posts Section -->
<style>#recent-blog-posts .card {
  transition: all 0.4s ease;
}
#recent-blog-posts .card:hover {
  transform: translateY(-8px);
  box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15);
}
#recent-blog-posts .author-name {
  font-weight: 500;
}
#recent-blog-posts .likes i {
  color: #28a745;
}
</style>
</main>


   

<script>
document.addEventListener('DOMContentLoaded', function() {
  new PureCounter();
});
</script>






<script>
// Initialize AOS animations
if (typeof AOS !== 'undefined') {
  AOS.init({
    duration: 800,
    once: true
  });
}

// Add intersection observer for scroll animations
const observerOptions = {
  threshold: 0.1,
  rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      entry.target.style.opacity = '1';
      entry.target.style.transform = 'translateY(0)';
    }
  });
}, observerOptions);

// Observe testimonial cards
document.querySelectorAll('.testimonial-card').forEach(card => {
  card.style.opacity = '0';
  card.style.transform = 'translateY(30px)';
  card.style.transition = 'all 0.6s ease';
  observer.observe(card);
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('apps', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/index.blade.php ENDPATH**/ ?>