<!-- resources/views/admin/teachers/index.blade.php -->


<?php $__env->startSection('title', 'Manage Teachers'); ?>
<?php $__env->startSection('page-title', 'Teachers Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center py-3 mb-4 border-bottom">
    <h1 class="h2"><i class="fas fa-chalkboard-teacher"></i> Teachers</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="<?php echo e(route('admin.teachers.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Teacher
        </a>
    </div>
</div>



<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle"></i> <?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Teachers</h5>
        <span class="badge bg-primary"><?php echo e($teachers->total()); ?> Teachers</span>
    </div>
    <div class="card-body">
        <?php if($teachers->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Profile</th>
                            <th>Teacher Info</th>
                            <th>Contact</th>
                            <th>Experience</th>
                            <th>Courses</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>
                                <?php if($teacher->profile_image): ?>
                                    <img src="<?php echo e(asset($teacher->profile_image)); ?>" 
                                         class="rounded-circle" width="50" height="50" 
                                         style="object-fit: cover;" alt="<?php echo e($teacher->name); ?>">
                                <?php else: ?>
                                    <div class="bg-light rounded-circle d-flex align-items-center justify-content-center" 
                                         style="width: 50px; height: 50px;">
                                        <i class="fas fa-user text-muted"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?php echo e($teacher->name); ?></strong>
                                <?php if($teacher->specialization): ?>
                                    <br><small class="text-muted"><?php echo e($teacher->specialization); ?></small>
                                <?php endif; ?>
                                <?php if($teacher->is_featured): ?>
                                    <br><span class="badge bg-warning mt-1">Featured</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div><i class="fas fa-envelope text-muted me-2"></i><?php echo e($teacher->email); ?></div>
                                <?php if($teacher->phone): ?>
                                    <div><i class="fas fa-phone text-muted me-2"></i><?php echo e($teacher->phone); ?></div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($teacher->experience_years > 0): ?>
                                    <span class="badge bg-info"><?php echo e($teacher->experience_years); ?> years</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">No experience</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge bg-primary"><?php echo e($teacher->courses_count ?? 0); ?></span>
                            </td>
                            <td>
                                <?php if($teacher->is_active): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="<?php echo e(route('admin.teachers.show', $teacher)); ?>" 
                                       class="btn btn-sm btn-outline-info" data-bs-toggle="tooltip" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.teachers.edit', $teacher)); ?>" 
                                       class="btn btn-sm btn-outline-primary" data-bs-toggle="tooltip" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.teachers.destroy', $teacher)); ?>" 
                                          method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger" 
                                                onclick="return confirm('Are you sure you want to delete this teacher?')"
                                                data-bs-toggle="tooltip" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($teachers->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-chalkboard-teacher fa-4x text-muted mb-3"></i>
                <h5 class="text-muted">No teachers found</h5>
                <p class="text-muted">Get started by adding your first teacher.</p>
                <a href="<?php echo e(route('admin.teachers.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Teacher
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    })
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/teachers/index.blade.php ENDPATH**/ ?>