

<?php $__env->startSection('content'); ?>
<style>
/* ========= Modern Color Palette ========= */
:root {
    --primary: #20c997;
    --primary-dark: #17a589;
    --primary-light: #e8f8f5;
    --secondary: #6f42c1;
    --accent: #ff6b35;
    --dark: #1a1d24;
    --darker: #15181e;
    --light: #ffffff;
    --gray: #8b95a5;
    --gray-light: #f8f9fa;
    --border: #e9ecef;
    --shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
    --shadow-hover: 0 20px 60px rgba(0, 0, 0, 0.15);
}

/* ========= Modern Hero Section ========= */
.hero-section {
    background: linear-gradient(135deg, var(--darker) 0%, var(--dark) 100%);
    padding: 120px 0 80px;
    position: relative;
    overflow: hidden;
}

.hero-section::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: 
        radial-gradient(circle at 20% 80%, rgba(32, 201, 151, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(111, 66, 193, 0.1) 0%, transparent 50%);
    animation: float 6s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

.hero-content {
    position: relative;
    z-index: 2;
    text-align: center;
}

.hero-title {
    font-size: 3.5rem;
    font-weight: 800;
    background: linear-gradient(135deg, #fff 0%, #20c997 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin-bottom: 1.5rem;
    line-height: 1.2;
}

.hero-subtitle {
    font-size: 1.2rem;
    color: rgba(255, 255, 255, 0.8);
    margin-bottom: 2rem;
    max-width: 600px;
    margin-left: auto;
    margin-right: auto;
}

.breadcrumb-modern {
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
    transition: all 0.3s ease;
    font-weight: 500;
}

.breadcrumb-modern a:hover {
    color: var(--primary);
}

.breadcrumb-modern .separator {
    color: rgba(255, 255, 255, 0.5);
}

/* ========= Stats Section ========= */
.stats-section {
    background: var(--light);
    padding: 4rem 0;
    position: relative;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
    text-align: center;
}

.stat-card {
    background: white;
    padding: 2.5rem 2rem;
    border-radius: 20px;
    box-shadow: var(--shadow);
    transition: all 0.3s ease;
    border: 1px solid var(--border);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: var(--shadow-hover);
}

.stat-number {
    font-size: 3rem;
    font-weight: 800;
    background: linear-gradient(135deg, var(--primary), var(--secondary));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    line-height: 1;
    margin-bottom: 0.5rem;
}

.stat-label {
    color: var(--gray);
    font-weight: 600;
    font-size: 1rem;
}

/* ========= Instructors Grid ========= */
.instructors-section {
    padding: 5rem 0;
    background: var(--gray-light);
}

.instructors-header {
    text-align: center;
    margin-bottom: 4rem;
}

.section-title {
    font-size: 2.5rem;
    font-weight: 800;
    color: var(--dark);
    margin-bottom: 1rem;
}

.section-subtitle {
    font-size: 1.1rem;
    color: var(--gray);
    max-width: 600px;
    margin: 0 auto;
}

.instructors-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 2rem;
}

/* ========= Modern Instructor Card ========= */
.instructor-card-modern {
    background: white;
    border-radius: 24px;
    overflow: hidden;
    box-shadow: var(--shadow);
    transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    position: relative;
    border: 1px solid var(--border);
}

.instructor-card-modern:hover {
    transform: translateY(-12px);
    box-shadow: var(--shadow-hover);
}

/* ========= Card Image with Gradient Overlay ========= */
.card-image-container {
    position: relative;
    height: 280px;
    overflow: hidden;
}

.card-image-container img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.6s ease;
}

.instructor-card-modern:hover .card-image-container img {
    transform: scale(1.1);
}

.image-overlay {
    position: absolute;
    inset: 0;
    background: linear-gradient(to bottom, transparent 40%, rgba(0, 0, 0, 0.8));
    opacity: 0.8;
    transition: opacity 0.3s ease;
}

.instructor-card-modern:hover .image-overlay {
    opacity: 0.9;
}

/* ========= Floating Social Icons ========= */
.social-floating {
    position: absolute;
    top: 20px;
    right: 20px;
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
    transform: translateX(100px);
    opacity: 0;
    transition: all 0.4s ease;
}

.instructor-card-modern:hover .social-floating {
    transform: translateX(0);
    opacity: 1;
}

.social-icon {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--dark);
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.social-icon:hover {
    background: var(--primary);
    color: white;
    transform: scale(1.1);
}

/* ========= Card Content ========= */
.card-content {
    padding: 2rem;
    position: relative;
}

.instructor-badge {
    position: absolute;
    top: -20px;
    left: 2rem;
    background: linear-gradient(135deg, var(--primary), var(--secondary));
    color: white;
    padding: 0.5rem 1.25rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 700;
    box-shadow: 0 5px 15px rgba(32, 201, 151, 0.3);
}

.instructor-name {
    font-size: 1.5rem;
    font-weight: 800;
    color: var(--dark);
    margin-bottom: 0.5rem;
    line-height: 1.3;
}

.instructor-name a {
    color: inherit;
    text-decoration: none;
    transition: color 0.3s ease;
}

.instructor-name a:hover {
    color: var(--primary);
}

.instructor-role {
    color: var(--primary);
    font-weight: 600;
    font-size: 1rem;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.instructor-bio {
    color: var(--gray);
    line-height: 1.6;
    margin-bottom: 1.5rem;
    font-size: 0.95rem;
}

/* ========= Stats Row ========= */
.stats-row {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
    margin-bottom: 1.5rem;
    padding: 1rem;
    background: var(--primary-light);
    border-radius: 12px;
}

.stat-item {
    text-align: center;
}

.stat-value {
    font-size: 1.25rem;
    font-weight: 800;
    color: var(--dark);
    display: block;
}

.stat-label-small {
    font-size: 0.8rem;
    color: var(--gray);
    font-weight: 600;
}

/* ========= Action Button ========= */
.action-button {
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
    background: linear-gradient(135deg, var(--primary), var(--primary-dark));
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    text-decoration: none;
    font-weight: 700;
    transition: all 0.3s ease;
    border: none;
    width: 100%;
    justify-content: center;
    box-shadow: 0 4px 15px rgba(32, 201, 151, 0.3);
}

.action-button:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(32, 201, 151, 0.4);
    color: white;
}

/* ========= Pagination Modern ========= */
.pagination-modern {
    display: flex;
    justify-content: center;
    gap: 0.5rem;
    margin-top: 4rem;
}

.pagination-modern .page-link {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: 2px solid var(--border);
    background: white;
    color: var(--dark);
    text-decoration: none;
    font-weight: 700;
    transition: all 0.3s ease;
}

.pagination-modern .page-link:hover,
.pagination-modern .page-link.active {
    background: var(--primary);
    border-color: var(--primary);
    color: white;
    transform: translateY(-2px);
}

/* ========= No Content State ========= */
.no-content {
    text-align: center;
    padding: 4rem 2rem;
    background: white;
    border-radius: 24px;
    box-shadow: var(--shadow);
}

.no-content-icon {
    font-size: 4rem;
    color: var(--primary);
    margin-bottom: 1.5rem;
}

/* ========= Responsive Design ========= */
@media (max-width: 768px) {
    .hero-title {
        font-size: 2.5rem;
    }
    
    .instructors-grid {
        grid-template-columns: 1fr;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .stats-row {
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    
    .social-floating {
        position: static;
        flex-direction: row;
        transform: none;
        opacity: 1;
        margin-bottom: 1rem;
        justify-content: center;
    }
}

/* ========= Animation Classes ========= */
.fade-in-up {
    animation: fadeInUp 0.8s ease-out;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(40px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.stagger-animation > * {
    animation: fadeInUp 0.8s ease-out;
    animation-fill-mode: both;
}

.stagger-animation > *:nth-child(1) { animation-delay: 0.1s; }
.stagger-animation > *:nth-child(2) { animation-delay: 0.2s; }
.stagger-animation > *:nth-child(3) { animation-delay: 0.3s; }
.stagger-animation > *:nth-child(4) { animation-delay: 0.4s; }
.stagger-animation > *:nth-child(5) { animation-delay: 0.5s; }
.stagger-animation > *:nth-child(6) { animation-delay: 0.6s; }
</style>

<main class="main">

    <!-- Modern Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="hero-content fade-in-up">
                <h1 class="hero-title">Meet Our Expert Instructors</h1>
                <p class="hero-subtitle">Learn from industry professionals with years of experience and passion for teaching</p>
                <nav class="breadcrumb-modern">
                    <a href="<?php echo e(url('/')); ?>">Home</a>
                    <span class="separator">/</span>
                    <span class="text-white">Instructors</span>
                </nav>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="container">
            <div class="stats-grid">
                <div class="stat-card fade-in-up">
                    <div class="stat-number"><?php echo e($teachers->total()); ?>+</div>
                    <div class="stat-label">Expert Instructors</div>
                </div>
                <div class="stat-card fade-in-up">
                    <div class="stat-number"><?php echo e($totalExperience ?? '50'); ?>+</div>
                    <div class="stat-label">Years Experience</div>
                </div>
                <div class="stat-card fade-in-up">
                    <div class="stat-number"><?php echo e($totalCourses ?? '100'); ?>+</div>
                    <div class="stat-label">Courses Taught</div>
                </div>
                <div class="stat-card fade-in-up">
                    <div class="stat-number"><?php echo e($totalStudents ?? '5000'); ?>+</div>
                    <div class="stat-label">Students Trained</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Instructors Section -->
    <section class="instructors-section">
        <div class="container">
            <div class="instructors-header fade-in-up">
                <h2 class="section-title">Our Teaching Team</h2>
                <p class="section-subtitle">Passionate educators dedicated to your learning journey</p>
            </div>

            <?php if($teachers->count()): ?>
            <div class="instructors-grid stagger-animation">
                <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="instructor-card-modern">
                    <!-- Image Section -->
                    <div class="card-image-container">
                        <img src="<?php echo e(asset($teacher->profile_image ?? 'assets/images/default-teacher.jpg')); ?>" alt="<?php echo e($teacher->name); ?>">
                        <div class="image-overlay"></div>
                        
                        <!-- Floating Social Icons -->
                        <div class="social-floating">
                            <?php if($teacher->facebook_url): ?>
                                <a href="<?php echo e($teacher->facebook_url); ?>" class="social-icon" target="_blank">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                            <?php endif; ?>
                            <?php if($teacher->twitter_url): ?>
                                <a href="<?php echo e($teacher->twitter_url); ?>" class="social-icon" target="_blank">
                                    <i class="fab fa-twitter"></i>
                                </a>
                            <?php endif; ?>
                            <?php if($teacher->linkedin_url): ?>
                                <a href="<?php echo e($teacher->linkedin_url); ?>" class="social-icon" target="_blank">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Content Section -->
                    <div class="card-content">
                        <div class="instructor-badge">
                            <i class="fas fa-star me-1"></i>Expert
                        </div>
                        
                        <h3 class="instructor-name">
                            <a href="<?php echo e(route('teacherdetails', $teacher->slug)); ?>"><?php echo e($teacher->name); ?></a>
                        </h3>
                        
                        <div class="instructor-role">
                            <i class="fas fa-user-graduate"></i>
                            <?php echo e($teacher->specialization); ?>

                        </div>
                        
                        <p class="instructor-bio">
                            <?php echo e(Str::limit($teacher->bio, 120)); ?>

                        </p>

                        <!-- Stats Row -->
                        <div class="stats-row">
                            <div class="stat-item">
                                <span class="stat-value"><?php echo e($teacher->experience_years); ?>+</span>
                                <span class="stat-label-small">Years</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-value"><?php echo e($teacher->courses_count ?? '5'); ?>+</span>
                                <span class="stat-label-small">Courses</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-value"><?php echo e($teacher->students_count ?? '500'); ?>+</span>
                                <span class="stat-label-small">Students</span>
                            </div>
                        </div>

                        <a href="<?php echo e(route('teacherdetails', $teacher->slug)); ?>" class="action-button">
                            View Profile
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Modern Pagination -->
            <div class="pagination-modern">
                <?php echo e($teachers->onEachSide(1)->links('pagination::bootstrap-5')); ?>

            </div>

            <?php else: ?>
            <div class="no-content fade-in-up">
                <div class="no-content-icon">
                    <i class="fas fa-users"></i>
                </div>
                <h3>No Instructors Available</h3>
                <p>We're assembling our team of expert instructors. Check back soon!</p>
            </div>
            <?php endif; ?>

        </div>
    </section>
</main>

<!-- Custom Pagination View (resources/views/vendor/pagination/custom.blade.php) -->
<?php if($teachers->hasPages()): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add custom classes to pagination
    const paginationLinks = document.querySelectorAll('.pagination-modern .page-link');
    paginationLinks.forEach(link => {
        if (link.textContent.trim() === '‹' || link.textContent.trim() === '›') {
            link.innerHTML = `<i class="fas fa-chevron-${link.textContent.trim() === '‹' ? 'left' : 'right'}"></i>`;
        }
    });
});
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('apps', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/teacher.blade.php ENDPATH**/ ?>