<?php $__env->startSection('title', 'Home Content Management'); ?>
<?php $__env->startSection('page-title', 'Home Content Management'); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
<!-- Page Header -->
<div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
    <h2 class="fw-semibold mb-0 text-dark">
        <i class="fas fa-home text-success me-2"></i>
        Home Content
    </h2>
   <a href="<?php echo e($contentExists ? '#' : route('admin.home.create')); ?>"
   class="btn btn-success rounded-pill px-4 <?php echo e($contentExists ? 'disabled' : ''); ?>"
   <?php echo e($contentExists ? 'onclick=return false;' : ''); ?>>
    <i class="fas fa-plus me-2"></i>Add Content
</a>

</div>
    <!-- Card -->
    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
            <?php if($homeContents->count()): ?>
                <!-- Table wrapper -->
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th scope="col" class="fw-semibold">#</th>
                                <th scope="col" class="fw-semibold">Title</th>
                                <th scope="col" class="fw-semibold">Hero Heading</th>
                                <th scope="col" class="fw-semibold">Status</th>
                                <th scope="col" class="fw-semibold">Image</th>
                                <th scope="col" class="fw-semibold">Created</th>
                                <th scope="col" class="fw-semibold text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $homeContents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="fw-medium"><?php echo e($content->id); ?></td>
                                    <td class="text-truncate" style="max-width: 200px;"><?php echo e($content->title); ?></td>
                                    <td class="text-truncate" style="max-width: 200px;"><?php echo e($content->hero_heading); ?></td>
                                    <td>
                                        <span class="badge rounded-pill <?php echo e($content->is_active ? 'bg-success' : 'bg-secondary'); ?>">
                                            <?php echo e($content->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td>
    <?php if($content->image): ?>
        <img src="<?php echo e(asset('home/' . $content->image)); ?>" 
             alt="Thumb" 
             class="rounded-3" 
             style="width:48px;height:48px;object-fit:cover;">
    <?php else: ?>
        <div class="bg-light rounded-3 d-inline-flex align-items-center justify-content-center" style="width:48px;height:48px;">
            <i class="fas fa-image text-muted"></i>
        </div>
    <?php endif; ?>
</td>

                                    <td><?php echo e($content->created_at->format('M d, Y')); ?></td>
                        <td class="text-center">
    <div class="dropdown">
        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" id="action<?php echo e($content->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="fas fa-ellipsis-v"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="action<?php echo e($content->id); ?>">
            <li>
                <a class="dropdown-item" href="<?php echo e(route('admin.home.show', $content)); ?>">
                    <i class="fas fa-eye text-primary me-2"></i>View
                </a>
            </li>
            <li>
                <a class="dropdown-item" href="<?php echo e(route('admin.home.edit', $content)); ?>">
                    <i class="fas fa-edit text-success me-2"></i>Update
                </a>
            </li>
            <li>
                <form action="<?php echo e(route('admin.home.destroy', $content)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete this content?')">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="dropdown-item text-danger">
                        <i class="fas fa-trash me-2"></i>Remove
                    </button>
                </form>
            </li>
        </ul>
    </div>
</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if($homeContents->hasPages()): ?>
                    <div class="d-flex justify-content-center pt-4">
                        <?php echo e($homeContents->links('pagination::bootstrap-4')); ?>

                    </div>
                <?php endif; ?>
            <?php else: ?>
                <!-- Empty State -->
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="fas fa-home fa-3x text-success opacity-75"></i>
                    </div>
                    <h5 class="fw-semibold text-dark mb-2">No content yet</h5>
                    <p class="text-muted mb-4">Add your first home page content to get started.</p>
                    <a href="<?php echo e(route('admin.home.create')); ?>" class="btn btn-success rounded-pill px-4">
                        <i class="fas fa-plus me-2"></i>Add Home Content
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/home/index.blade.php ENDPATH**/ ?>