<?php $__env->startSection('title', 'Admin Users Management'); ?>
<?php $__env->startSection('page-title', 'Admin Users Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

  <!-- Header -->
  <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
    <h2 class="fw-bold text-dark mb-0">
      <i class="fas fa-users text-success me-2"></i>Admin Users
    </h2>
    <a href="<?php echo e(route('admin.admin-users.create')); ?>" class="btn btn-success rounded-pill px-4">
      <i class="fas fa-plus me-2"></i>Add Admin
    </a>
  </div>

  <!-- Card -->
  <div class="card border-0 rounded-4 shadow-sm">
    <div class="card-body p-4">

      <?php if($adminUsers->count()): ?>
        <div class="table-responsive">
          <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th class="fw-semibold">#</th>
                <th class="fw-semibold">Name</th>
                <th class="fw-semibold">Email</th>
                <th class="fw-semibold">Created</th>
                <th class="fw-semibold text-center">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $adminUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($user->id); ?></td>
                <td>
                  <?php echo e($user->name); ?>

                  <?php if($user->id === auth('admin')->id()): ?>
                    <span class="badge bg-info ms-1">You</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($user->email); ?></td>
                <td><?php echo e($user->created_at?->format('M d, Y') ?? 'N/A'); ?></td>
                <td class="text-center">
                  <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                      <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                      <li><a class="dropdown-item" href="<?php echo e(route('admin.admin-users.show', $user)); ?>"><i class="fas fa-eye text-primary me-2"></i>View</a></li>
                      <li><a class="dropdown-item" href="<?php echo e(route('admin.admin-users.edit', $user)); ?>"><i class="fas fa-edit text-warning me-2"></i>Edit</a></li>
                      <?php if($user->id !== auth('admin')->id() && $adminUsers->total() > 1): ?>
                        <li>
                          <form action="<?php echo e(route('admin.admin-users.destroy', $user)); ?>" method="POST" onsubmit="return confirm('Delete this admin?')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="dropdown-item text-danger"><i class="fas fa-trash me-2"></i>Delete</button>
                          </form>
                        </li>
                      <?php endif; ?>
                    </ul>
                  </div>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
          </table>
        </div>

        <?php if($adminUsers->hasPages()): ?>
          <div class="d-flex justify-content-center mt-4"><?php echo e($adminUsers->links('pagination::bootstrap-4')); ?></div>
        <?php endif; ?>

      <?php else: ?>
        <div class="text-center py-5">
          <i class="fas fa-users fa-3x text-success opacity-75 mb-3"></i>
          <h5 class="fw-semibold text-dark mb-2">No admin users yet</h5>
          <p class="text-muted mb-4">Add your first admin user to get started.</p>
          <a href="<?php echo e(route('admin.admin-users.create')); ?>" class="btn btn-success rounded-pill px-4">
            <i class="fas fa-plus me-2"></i>Add Admin
          </a>
        </div>
      <?php endif; ?>

    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/admin-users/index.blade.php ENDPATH**/ ?>