<!-- resources/views/admin/courses/index.blade.php -->


<?php $__env->startSection('title', 'Manage Courses'); ?>
<?php $__env->startSection('page-title', 'Courses Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center py-3 mb-4 border-bottom">
    <div class="d-flex align-items-center">
        <div class="icon-wrapper bg-primary me-3">
            <i class="fas fa-book-open text-white"></i>
        </div>
        <div>
            <h1 class="h2 mb-0">Course Management</h1>
            <p class="text-muted mb-0">Manage all your courses in one place</p>
        </div>
    </div>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="<?php echo e(route('admin.courses.create')); ?>" class="btn btn-primary btn-lg">
            <i class="fas fa-plus-circle me-2"></i> Create New Course
        </a>
    </div>
</div>



<!-- Stats Overview -->
<!-- <div class="row mb-5">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="stat-icon-wrapper bg-primary me-3">
                        <i class="fas fa-book text-white"></i>
                    </div>
                    <div>
                        <h3 class="stat-number mb-0"><?php echo e($courses->total()); ?></h3>
                        <p class="stat-text mb-0">Total Courses</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="stat-icon-wrapper bg-success me-3">
                        <i class="fas fa-users text-white"></i>
                    </div>
                    <div>
                        <h3 class="stat-number mb-0"><?php echo e($courses->sum('total_students')); ?></h3>
                        <p class="stat-text mb-0">Total Students</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="stat-icon-wrapper bg-warning me-3">
                        <i class="fas fa-star text-white"></i>
                    </div>
                    <div>
                        <h3 class="stat-number mb-0"><?php echo e($courses->where('is_featured', true)->count()); ?></h3>
                        <p class="stat-text mb-0">Featured</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="stat-icon-wrapper bg-info me-3">
                        <i class="fas fa-chart-line text-white"></i>
                    </div>
                    <div>
                        <h3 class="stat-number mb-0"><?php echo e(number_format($courses->avg('ratings'), 1)); ?>/5</h3>
                        <p class="stat-text mb-0">Avg Rating</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> -->

<!-- Course Grid -->
<div class="row">
    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="col-xl-4 col-lg-6 mb-4">
        <div class="course-card-wrapper">
            <div class="course-card">
                <!-- Course Header with Image -->
                <div class="course-header">
                    <?php if($course->image): ?>
                        <img src="<?php echo e(asset($course->image)); ?>" class="course-image" alt="<?php echo e($course->title); ?>">
                    <?php else: ?>
                        <div class="course-image-placeholder">
                            <i class="fas fa-book-open"></i>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Labels -->
                    <div class="course-labels">
                        <?php if($course->label): ?>
                            <span class="course-label label-<?php echo e($course->label); ?>">
                                <i class="fas fa-tag me-1"></i><?php echo e(ucfirst($course->label)); ?>

                            </span>
                        <?php endif; ?>
                        <?php if($course->is_featured): ?>
                            <span class="course-label label-featured">
                                <i class="fas fa-crown me-1"></i>Featured
                            </span>
                        <?php endif; ?>
                    </div>

                    <!-- Quick Actions -->
                    <div class="course-actions">
                        <div class="btn-group ">
                            <a href="<?php echo e(route('admin.courses.show', $course)); ?>" class="btn btn-action btn-info text-white" data-bs-toggle="tooltip" title="View">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.courses.edit', $course)); ?>" class="btn btn-action btn-secondary" data-bs-toggle="tooltip" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="<?php echo e(route('admin.courses.destroy', $course)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-action btn-danger" 
                                        onclick="return confirm('Are you sure?')" data-bs-toggle="tooltip" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Course Body -->
                <div class="course-body">
                    <!-- Category & Level -->
                    <div class="course-meta">
                        <span class="meta-category">
                            <i class="fas fa-tags me-1"></i>
                            <?php echo e($course->category->name); ?>

                        </span>
                        <span class="meta-level level-<?php echo e($course->level); ?>">
                            <i class="fas fa-signal me-1"></i>
                            <?php echo e(ucfirst($course->level)); ?>

                        </span>
                    </div>

                    <!-- Title -->
                    <h5 class="course-title"><?php echo e($course->title); ?></h5>
                    
                    <!-- Description -->
                    <p class="course-description"><?php echo e(Str::limit($course->description, 120)); ?></p>

                    <!-- Rating & Certificate -->
                    <div class="course-features">
                        <div class="rating-wrapper">
                            <div class="stars">
                                <?php
                                    $fullStars = floor($course->ratings);
                                    $halfStar = ($course->ratings - $fullStars) >= 0.5 ? 1 : 0;
                                    $emptyStars = 5 - ($fullStars + $halfStar);
                                ?>

                                <?php for($i = 1; $i <= $fullStars; $i++): ?>
                                    <i class="fas fa-star"></i>
                                <?php endfor; ?>

                                <?php if($halfStar): ?>
                                    <i class="fas fa-star-half-alt"></i>
                                <?php endif; ?>

                                <?php for($i = 1; $i <= $emptyStars; $i++): ?>
                                    <i class="far fa-star"></i>
                                <?php endfor; ?>
                            </div>
                            <span class="rating-text"><?php echo e(number_format($course->ratings, 1)); ?></span>
                        </div>
                        
                        <?php if($course->has_certificate): ?>
                            <div class="certificate-badge">
                                <i class="fas fa-award"></i>
                                <span>Certificate</span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Duration & Students -->
                    <div class="course-stats">
                        <div class="stat-item">
                            <i class="fas fa-clock"></i>
                            <span><?php echo e($course->duration_value); ?> <?php echo e($course->duration_type); ?></span>
                        </div>
                        <div class="stat-item">
                            <i class="fas fa-users"></i>
                            <span><?php echo e($course->total_students); ?> students</span>
                        </div>
                    </div>

                    <!-- Teacher Info -->
                    <div class="teacher-info">
                        <div class="teacher-avatar">
                            <?php if($course->teacher->profile_image): ?>
                                <img src="<?php echo e(asset($course->teacher->profile_image)); ?>" alt="<?php echo e($course->teacher->name); ?>">
                            <?php else: ?>
                                <div class="avatar-placeholder">
                                    <i class="fas fa-user"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="teacher-details">
                            <span class="teacher-name"><?php echo e($course->teacher->name); ?></span>
                            <?php if($course->teacher->specialization): ?>
                                <span class="teacher-specialization"><?php echo e($course->teacher->specialization); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Course Footer -->
                <div class="course-footer">
                    <div class="price-section">
                        <?php if($course->price_type === 'free'): ?>
                            <span class="price-free">
                                <i class="fas fa-gift me-1"></i>Free
                            </span>
                        <?php else: ?>
                            <span class="price-paid">
                                <i class="fas fa-dollar-sign me-1"></i><?php echo e(number_format($course->price, 2)); ?>

                            </span>
                        <?php endif; ?>
                    </div>
                    
                    <div class="status-badge">
                        <?php if($course->is_active): ?>
                            <span class="badge status-active  bg-success">
                                <i class="fas fa-circle me-1"></i>Active
                            </span>
                        <?php else: ?>
                            <span class="badge status-inactive bg-dark">
                                <i class="fas fa-circle me-1"></i>Inactive
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>


<?php echo e($courses->links('pagination::bootstrap-5')); ?>

   

<?php $__env->stopSection(); ?>


<style>
    /* Main Card Styles */
    .course-card-wrapper {
        position: relative;
    }

    .course-card {
        background: #fff;
        border-radius: 20px;
        box-shadow: 0 5px 25px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
        overflow: hidden;
        border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .course-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
    }

    /* Header Section */
    .course-header {
        position: relative;
        height: 200px;
        overflow: hidden;
    }

    .course-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }

    .course-card:hover .course-image {
        transform: scale(1.05);
    }

    .course-image-placeholder {
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 3rem;
    }

    /* Labels */
    .course-labels {
        position: absolute;
        top: 15px;
        left: 15px;
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .course-label {
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
    }

    .label-new {
        background: linear-gradient(135deg, #ff6b6b, #ee5a24);
        color: white;
    }

    .label-popular {
        background: linear-gradient(135deg, #4834d4, #686de0);
        color: white;
    }

    .label-featured {
        background: linear-gradient(135deg, #f9ca24, #f0932b);
        color: white;
    }

    /* Actions */
    .course-actions {
        position: absolute;
        top: 15px;
        right: 15px;
        opacity: 0;
        transform: translateY(-10px);
        transition: all 0.3s ease;
    }

    .course-card:hover .course-actions {
        opacity: 1;
        transform: translateY(0);
    }

    .btn-action {
        width: 35px;
        height: 35px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(255, 255, 255, 0.95);
        border: none;
        color: #666;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
    }

    .btn-action:hover {
        background: #fff;
        color: #333;
        transform: scale(1.1);
    }

    .btn-action.btn-danger:hover {
        background: #dc3545;
        color: white;
    }

    /* Body Section */
    .course-body {
        padding: 25px;
    }

    .course-meta {
        display: flex;
        gap: 10px;
        margin-bottom: 15px;
    }

    .meta-category, .meta-level {
        padding: 6px 12px;
        border-radius: 15px;
        font-size: 0.75rem;
        font-weight: 500;
    }

    .meta-category {
        background: rgba(102, 126, 234, 0.1);
        color: #667eea;
    }

    .level-beginner { background: rgba(40, 167, 69, 0.1); color: #28a745; }
    .level-intermediate { background: rgba(255, 193, 7, 0.1); color: #ffc107; }
    .level-advanced { background: rgba(220, 53, 69, 0.1); color: #dc3545; }

    .course-title {
        font-weight: 700;
        font-size: 1.25rem;
        line-height: 1.4;
        margin-bottom: 12px;
        color: #2d3748;
    }

    .course-description {
        color: #718096;
        font-size: 0.9rem;
        line-height: 1.5;
        margin-bottom: 20px;
    }

    /* Features */
    .course-features {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        padding: 15px;
        background: #f8f9fa;
        border-radius: 12px;
    }

    .rating-wrapper {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .stars {
        color: #ffc107;
    }

    .rating-text {
        font-weight: 600;
        color: #4a5568;
        font-size: 0.9rem;
    }

    .certificate-badge {
        display: flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        background: rgba(40, 167, 69, 0.1);
        color: #28a745;
        border-radius: 15px;
        font-size: 0.8rem;
        font-weight: 500;
    }

    /* Stats */
    .course-stats {
        display: flex;
        gap: 20px;
        margin-bottom: 20px;
    }

    .stat-item {
        display: flex;
        align-items: center;
        gap: 8px;
        color: #718096;
        font-size: 0.85rem;
    }

    .stat-item i {
        color: #667eea;
    }

    /* Teacher Info */
    .teacher-info {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 15px;
        background: linear-gradient(135deg, #f8f9fa, #e9ecef);
        border-radius: 15px;
        margin-bottom: 20px;
    }

    .teacher-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        overflow: hidden;
    }

    .teacher-avatar img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .avatar-placeholder {
        width: 100%;
        height: 100%;
        background: #667eea;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1rem;
    }

    .teacher-details {
        display: flex;
        flex-direction: column;
    }

    .teacher-name {
        font-weight: 600;
        color: #2d3748;
        font-size: 0.9rem;
    }

    .teacher-specialization {
        color: #718096;
        font-size: 0.8rem;
    }

    /* Footer */
    .course-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 20px 25px;
        background: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }

    .price-section {
        font-weight: 700;
        font-size: 1.25rem;
    }

    .price-free {
        color: #28a745;
    }

    .price-paid {
        color: #667eea;
    }

    .status-badge .badge {
        padding: 6px 12px;
        border-radius: 15px;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .status-active {
        background: rgba(40, 167, 69, 0.1);
        color: #28a745;
    }

    .status-inactive {
        background: rgba(108, 117, 125, 0.1);
        color: #6c757d;
    }

    /* Stats Cards */
    .stat-card {
        border-radius: 15px;
        transition: transform 0.3s ease;
    }

    .stat-card:hover {
        transform: translateY(-5px);
    }

    .stat-icon-wrapper {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .stat-number {
        font-weight: 700;
        color: #2d3748;
    }

    .stat-text {
        color: #718096;
        font-size: 0.9rem;
    }

    /* Icons */
    .icon-wrapper {
        width: 60px;
        height: 60px;
        border-radius: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* Alert */
    .alert-icon-wrapper {
        width: 24px;
        height: 24px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* Pagination */
    .pagination-wrapper {
        display: flex;
        justify-content: center;
    }

    .pagination-wrapper .pagination {
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .pagination-wrapper .page-link {
        border: none;
        padding: 12px 20px;
        color: #667eea;
    }

    .pagination-wrapper .page-item.active .page-link {
        background: #667eea;
        border-color: #667eea;
    }
</style>

<script>
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    })
</script>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/courses/index.blade.php ENDPATH**/ ?>