<?php $__env->startSection('title', 'Add Setting'); ?>
<?php $__env->startSection('page-title', 'Add Setting'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0"><i class="fas fa-plus-circle text-success me-2"></i>Add Setting</h2>
        <a href="<?php echo e(route('admin.settings.index')); ?>" class="btn btn-outline-secondary rounded-pill">
            <i class="fas fa-arrow-left me-2"></i>Back
        </a>
    </div>

    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
            <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Setting Key <span class="text-danger">*</span></label>
                        <input type="text" name="key" value="<?php echo e(old('key')); ?>" class="form-control rounded-3" placeholder="site_name" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Type <span class="text-danger">*</span></label>
                        <select name="type" id="type" class="form-select rounded-3" required>
                            <option value="">Choose…</option>
                            <option value="text">Text</option><option value="textarea">Textarea</option>
                            <option value="image">Image</option><option value="url">URL</option>
                            <option value="email">Email</option><option value="phone">Phone</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Display Label <span class="text-danger">*</span></label>
                        <input type="text" name="label" value="<?php echo e(old('label')); ?>" class="form-control rounded-3" placeholder="Site Name" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Value</label>
                        <input type="text" name="value" id="value" value="<?php echo e(old('value')); ?>" class="form-control rounded-3">
                    </div>
                </div>

                <div class="mb-3 mt-3" id="image-field" style="display:none;">
                    <label class="form-label fw-semibold">Image File</label>
                    <input type="file" name="image" accept="image/*" class="form-control rounded-3">
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Description</label>
                    <textarea name="description" rows="3" class="form-control rounded-3" placeholder="Short description"><?php echo e(old('description')); ?></textarea>
                </div>

                <div class="d-flex flex-column flex-sm-row justify-content-between gap-2">
                    <a href="<?php echo e(route('admin.settings.index')); ?>" class="btn btn-outline-secondary rounded-pill">Cancel</a>
                    <button type="submit" class="btn btn-success rounded-pill px-4">Save Setting</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('type').addEventListener('change', function () {
    const type = this.value;
    const valueInput = document.getElementById('value');
    const imageField = document.getElementById('image-field');

    imageField.style.display = type === 'image' ? 'block' : 'none';

    if (type === 'textarea') {
        valueInput.outerHTML = `<textarea name="value" id="value" rows="4" class="form-control rounded-3">${valueInput.value}</textarea>`;
    } else {
        const newInput = document.createElement('input');
        newInput.type = type === 'email' ? 'email' : (type === 'url' ? 'url' : 'text');
        newInput.name = 'value'; newInput.id = 'value';
        newInput.className = 'form-control rounded-3';
        newInput.value = valueInput.value;
        valueInput.parentNode.replaceChild(newInput, valueInput);
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/settings/create.blade.php ENDPATH**/ ?>