<?php $__env->startSection('title', 'View Specialty'); ?>
<?php $__env->startSection('page-title', 'View Specialty'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0"><i class="fas fa-star text-success me-2"></i><?php echo e($specialty->title); ?></h2>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('admin.specialties.edit', $specialty)); ?>" class="btn btn-outline-success rounded-pill">
                <i class="fas fa-edit me-1"></i>Edit
            </a>
            <form action="<?php echo e(route('admin.specialties.destroy', $specialty)); ?>" method="POST"
                  onsubmit="return confirm('Delete this specialty?')" class="d-inline">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-outline-danger rounded-pill">
                    <i class="fas fa-trash me-1"></i>Delete
                </button>
            </form>
        </div>
    </div>

    <div class="row g-4">
        <!-- Details -->
        <div class="col-lg-8">
            <div class="card border-0 rounded-4 shadow-sm h-100">
                <div class="card-body p-4">
                    <div class="row mb-2">
                        <div class="col-sm-4 fw-semibold text-muted">Description</div>
                        <div class="col-sm-8"><?php echo nl2br(e($specialty->description)); ?></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-sm-4 fw-semibold text-muted">Status</div>
                        <div class="col-sm-8">
                            <span class="badge rounded-pill <?php echo e($specialty->is_active ? 'bg-success' : 'bg-secondary'); ?>">
                                <?php echo e($specialty->is_active ? 'Active' : 'Inactive'); ?>

                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 fw-semibold text-muted">Created</div>
                        <div class="col-sm-8"><?php echo e($specialty->created_at->format('M d, Y h:i A')); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Image -->
        <div class="col-lg-4">
            <div class="card border-0 rounded-4 shadow-sm">
                <div class="card-body p-4 text-center">
                    <?php if($specialty->image): ?>
                        <img src="<?php echo e($specialty->image_url); ?>" alt="" class="img-fluid rounded-4 mb-3"
                             style="max-height: 220px; object-fit: cover;">
                        <a href="<?php echo e($specialty->image_url); ?>" target="_blank" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-eye me-1"></i>View Full Size
                        </a>
                    <?php else: ?>
                        <div class="bg-light rounded-4 d-flex align-items-center justify-content-center" style="height: 220px;">
                            <i class="fas fa-image fa-3x text-muted"></i>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="text-center mt-4">
        <a href="<?php echo e(route('admin.specialties.index')); ?>" class="btn btn-outline-secondary rounded-pill px-4">
            <i class="fas fa-arrow-left me-2"></i>Back to List
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/specialties/show.blade.php ENDPATH**/ ?>