<?php $__env->startSection('title', 'Add FAQ'); ?>
<?php $__env->startSection('page-title', 'Add FAQ'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
  <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
    <h2 class="fw-bold text-dark mb-0">
      <i class="fas fa-plus-circle text-success me-2"></i>Add FAQ
    </h2>
    <a href="<?php echo e(route('admin.faqs.index')); ?>" class="btn btn-outline-secondary rounded-pill">
      <i class="fas fa-arrow-left me-2"></i>Back
    </a>
  </div>

  <div class="card border-0 rounded-4 shadow-sm">
    <div class="card-body p-4">
      <form action="<?php echo e(route('admin.faqs.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="mb-3">
          <label class="form-label fw-semibold">Question <span class="text-danger">*</span></label>
          <input type="text" name="question" value="<?php echo e(old('question')); ?>" class="form-control rounded-3" required>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Answer <span class="text-danger">*</span></label>
          <textarea name="answer" rows="4" class="form-control rounded-3" required><?php echo e(old('answer')); ?></textarea>
        </div>

        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label fw-semibold">Sort Order</label>
            <input type="number" name="sort_order" value="<?php echo e(old('sort_order', 0)); ?>" min="0" class="form-control rounded-3">
            <div class="form-text">Lower = first</div>
          </div>
          <div class="col-md-6">
            <label class="form-label fw-semibold">Status</label>
            <select name="is_active" class="form-select rounded-3">
              <option value="1" selected>Active</option>
              <option value="0">Inactive</option>
            </select>
          </div>
        </div>

        <div class="d-flex flex-column flex-sm-row justify-content-between gap-2 mt-4">
          <a href="<?php echo e(route('admin.faqs.index')); ?>" class="btn btn-outline-secondary rounded-pill">Cancel</a>
          <button type="submit" class="btn btn-success rounded-pill px-4">Save FAQ</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/faqs/create.blade.php ENDPATH**/ ?>