
<?php $__env->startSection('title', 'Add Categories'); ?>
<?php $__env->startSection('page-title', 'Add Categorie'); ?>

<?php $__env->startSection('content'); ?>
          <div class="content-wrapper">
            <div class="row">
            
 <div class="container mt-4">
      <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0"><i class="fas fa-tag text-success me-2"></i>Blog Categories</h2>
        <a href="<?php echo e(route('admin.categories.create')); ?>" class="btn btn-success rounded-pill px-4">
            <i class="fas fa-plus me-2"></i>Add New Category
        </a>
    </div>

  

    <table class="table  table-striped " id="blogsTable">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(++$key); ?></td>
                    <td><?php echo e($category->name); ?></td>
                    <td>
                        <a href="<?php echo e(route('admin.categories.edit', $category->id)); ?>" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i> Update</a>
                        <form action="<?php echo e(route('admin.categories.destroy', $category->id)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm" onclick="return confirm('Delete this category?')"><i class="fas fa-trash"></i> Remove</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php echo e($categories->links()); ?>

</div>
        </div>
              </div>
        

<?php $__env->startPush('scripts'); ?>
    <!-- jQuery and Datatables JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#blogsTable').DataTable({
                "paging": true, // Enable pagination
                "lengthChange": false, // Disable entries per page change
                "searching": true, // Enable search
                "ordering": true, // Enable column sorting
                "info": true, // Show information about current page
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/categories/index.blade.php ENDPATH**/ ?>