<?php $__env->startSection('title', 'View Service'); ?>
<?php $__env->startSection('page-title', 'View Service'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-cogs me-2"></i>
                    Service Details
                </h5>
                <div>
                    <a href="<?php echo e(route('admin.services.edit', $service)); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit me-1"></i>Edit
                    </a>
                    <form action="<?php echo e(route('admin.services.destroy', $service)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this service?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger btn-sm">
                            <i class="fas fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <table class="table table-borderless">
                            <tr>
                                <th width="200">ID:</th>
                                <td><?php echo e($service->id); ?></td>
                            </tr>
                            <tr>
                                <th>Title:</th>
                                <td>
                                    <h5 class="text-primary"><?php echo e($service->title); ?></h5>
                                </td>
                            </tr>
                            <tr>
                                <th>Description:</th>
                                <td>
                                    <div class="p-3 bg-light rounded">
                                        <?php echo nl2br(e($service->description)); ?>

                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <th>Primary Image:</th>
                                <td>
                                    <?php if($service->image1): ?>
                                        <div class="mb-2">
                                            <img src="<?php echo e(Storage::url($service->image1)); ?>" 
                                                 alt="<?php echo e($service->title); ?>" 
                                                 class="img-thumbnail" 
                                                 style="max-width: 300px; max-height: 200px;">
                                        </div>
                                        <small class="text-muted"><?php echo e($service->image1); ?></small>
                                    <?php else: ?>
                                        <span class="text-muted">No primary image uploaded</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        
                            <tr>
                                <th>Status:</th>
                                <td>
                                    <?php if($service->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inactive</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Created At:</th>
                                <td><?php echo e($service->created_at->format('M d, Y h:i A')); ?></td>
                            </tr>
                            <tr>
                                <th>Updated At:</th>
                                <td><?php echo e($service->updated_at->format('M d, Y h:i A')); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center">
                            <?php if($service->image1): ?>
                                <div class="mb-3">
                                    <img src="<?php echo e(Storage::url($service->image1)); ?>" 
                                         alt="<?php echo e($service->title); ?>" 
                                         class="img-fluid rounded shadow"
                                         style="max-height: 250px;">
                                </div>
                            <?php else: ?>
                                <div class="mb-3">
                                    <i class="fas fa-cogs fa-5x text-primary"></i>
                                </div>
                            <?php endif; ?>
                            <h6><?php echo e($service->title); ?></h6>
                            <p class="text-muted">Medical Service</p>
                            
                            <?php if($service->image1 || $service->image2): ?>
                                <div class="mt-3">
                                    <?php if($service->image1): ?>
                                        <a href="<?php echo e(Storage::url($service->image1)); ?>" 
                                           target="_blank" 
                                           class="btn btn-sm btn-outline-primary me-1">
                                            <i class="fas fa-eye me-1"></i>View Image 1
                                        </a>
                                    <?php endif; ?>
                                    <?php if($service->image2): ?>
                                        <a href="<?php echo e(Storage::url($service->image2)); ?>" 
                                           target="_blank" 
                                           class="btn btn-sm btn-outline-secondary">
                                            <i class="fas fa-eye me-1"></i>View Image 2
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card bg-light mt-4">
                    <div class="card-header">
                        <h6 class="mb-0">
                            <i class="fas fa-eye me-2"></i>Frontend Preview
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php if($service->image1): ?>
                                    <img src="<?php echo e(Storage::url($service->image1)); ?>" 
                                         alt="<?php echo e($service->title); ?>" 
                                         class="img-fluid rounded mb-3">
                                <?php else: ?>
                                    <div class="bg-secondary rounded d-flex align-items-center justify-content-center mb-3" style="height: 200px;">
                                        <i class="fas fa-image fa-3x text-white"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-6">
                                <?php if($service->image2): ?>
                                    <img src="<?php echo e(Storage::url($service->image2)); ?>" 
                                         alt="<?php echo e($service->title); ?>" 
                                         class="img-fluid rounded mb-3">
                                <?php else: ?>
                                    <div class="bg-secondary rounded d-flex align-items-center justify-content-center mb-3" style="height: 200px;">
                                        <i class="fas fa-image fa-3x text-white"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="text-center">
                            <h5><?php echo e($service->title); ?></h5>
                            <p class="text-muted"><?php echo e(Str::limit($service->description, 200)); ?></p>
                            <button class="btn btn-primary" disabled>Learn More</button>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a href="<?php echo e(route('admin.services.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                    <a href="<?php echo e(route('admin.services.edit', $service)); ?>" class="btn btn-primary">
                        <i class="fas fa-edit me-2"></i>Edit Service
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/services/show.blade.php ENDPATH**/ ?>