<?php $__env->startSection('title', 'Edit Service'); ?>
<?php $__env->startSection('page-title', 'Edit Service'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-4 gap-2">
        <h2 class="fw-bold text-dark mb-0">
            <i class="fas fa-edit text-success me-2"></i>Edit Service
        </h2>
        <a href="<?php echo e(route('admin.services.index')); ?>" class="btn btn-outline-secondary rounded-pill">
            <i class="fas fa-arrow-left me-2"></i>Back
        </a>
    </div>

    <div class="card border-0 rounded-4 shadow-sm">
        <div class="card-body p-4">
            <form action="<?php echo e(route('admin.services.update', $service)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Title <span class="text-danger">*</span></label>
                    <input type="text" name="title" value="<?php echo e(old('title', $service->title)); ?>" class="form-control rounded-3" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Short Description <span class="text-danger">*</span></label>
                    <input type="text" name="short" value="<?php echo e(old('short', $service->short)); ?>" class="form-control rounded-3" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Description <span class="text-danger">*</span></label>
                    <textarea name="description" id="description" rows="4" class="form-control rounded-3" required><?php echo e(old('description', $service->description)); ?></textarea>
                </div>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Primary Image</label>
                      
                        <input type="file" name="image_1" accept="image/*" class="form-control rounded-3">
                        <div class="form-text">Leave empty to keep current image</div>
                          <?php if($service->image_1): ?>
                            <img src="<?php echo e(asset('storage/services/' . $service->image_1)); ?>" alt="" class="rounded-3 mb-2" style="max-height: 120px;">
                        <?php endif; ?>
                    </div>
                   
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">Status</label>
                    <select name="is_active" class="form-select rounded-3">
                        <option value="1" <?php echo e($service->is_active ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(!$service->is_active ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>

                <div class="d-flex flex-column flex-sm-row justify-content-between gap-2">
                    <a href="<?php echo e(route('admin.services.index')); ?>" class="btn btn-outline-secondary rounded-pill">Cancel</a>
                    <button type="submit" class="btn btn-success rounded-pill px-4">Update Service</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script src="https://cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('description');
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/services/edit.blade.php ENDPATH**/ ?>