<?php $__env->startSection('title', 'About Pages'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">About Pages</h3>
                    <a href="<?php echo e(route('admin.about.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Create About Page
                    </a>
                </div>
                <div class="card-body">
                  
                    <?php if($aboutPages->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Main Image</th>
                                    <th>Years Exp</th>
                                    <th>Instructors</th>
                                    <th>Students</th>
                                    <th>Status</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $aboutPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aboutPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($aboutPage->id); ?></td>
                                    <td><?php echo e(Str::limit($aboutPage->title, 50)); ?></td>
                                    <td>
                                        <?php if($aboutPage->main_image): ?>
                                            <img src="<?php echo e(asset( $aboutPage->main_image)); ?>" alt="Main Image" width="60" height="60" style="object-fit: cover; border-radius: 5px;">
                                        <?php else: ?>
                                            <span class="badge badge-secondary">No Image</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($aboutPage->years_experience); ?></td>
                                    <td><?php echo e($aboutPage->expert_instructors); ?></td>
                                    <td><?php echo e($aboutPage->students_worldwide); ?></td>
                                    <td>
                                        <span class="badge <?php echo e($aboutPage->is_active ? 'badge-success' : 'badge-danger'); ?> text-dark">
                                            <?php echo e($aboutPage->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($aboutPage->created_at->format('d/m/Y')); ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('admin.about.show', $aboutPage->id)); ?>" class="btn btn-info" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.about.edit', $aboutPage->id)); ?>" class="btn btn-warning" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.about.destroy', $aboutPage->id)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger" title="Delete" onclick="return confirm('Are you sure you want to delete this about page?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-4">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <h4>No About Pages Found</h4>
                        <p class="text-muted">Get started by creating your first about page.</p>
                        <a href="<?php echo e(route('admin.about.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Create About Page
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
                <?php if($aboutPages->count() > 0): ?>
                <div class="card-footer">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            Showing <?php echo e($aboutPages->count()); ?> about page(s)
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
.btn-group-sm > .btn {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    line-height: 1.5;
    border-radius: 0.2rem;
}
.table th {
    border-top: none;
    font-weight: 600;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/about/index.blade.php ENDPATH**/ ?>