<?php $__env->startSection('title', 'View Contact Message'); ?>
<?php $__env->startSection('page-title', 'View Contact Message'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light text-white d-flex justify-content-between align-items-center rounded-top">
                <h5 class="mb-0 d-flex align-items-center text-dark">
                    <i class="fas fa-envelope me-2"></i>
                    Contact Message Details
                    <?php if(!$contact->is_read): ?>
                        <span class="badge bg-info text-dark ms-3">New</span>
                    <?php endif; ?>
                </h5>
                <form action="<?php echo e(route('admin.contacts.destroy', $contact)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this message?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-sm btn-danger">
                        <i class="fas fa-trash me-1"></i> Remove
                    </button>
                </form>
            </div>
            <div class="card-body px-4 py-3">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <table class="table table-sm table-borderless">
                            <tbody>
                                <tr>
                                    <th class="text-muted" width="150">Name:</th>
                                    <td><?php echo e($contact->name); ?></td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Email:</th>
                                    <td><a href="mailto:<?php echo e($contact->email); ?>"><?php echo e($contact->email); ?></a></td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Phone:</th>
                                    <td><?php echo e($contact->phone ?: 'Not provided'); ?></td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Subject:</th>
                                    <td><?php echo e($contact->subject ?: 'No subject'); ?></td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Status:</th>
                                    <td>
                                        <?php if($contact->is_read): ?>
                                            <span class="badge bg-success">Read</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning text-dark">Unread</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Received At:</th>
                                    <td><?php echo e($contact->created_at->format('M d, Y h:i A')); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="col-md-6 text-center">
                        <div class="bg-light rounded p-3 shadow-sm h-100 d-flex flex-column justify-content-center">
                            <h6 class="text-dark mb-3">Quick Actions</h6>
                            <div class="d-grid gap-2">
                                <a href="mailto:<?php echo e($contact->email); ?>" class="btn btn-outline-primary">
                                    <i class="fas fa-reply me-2"></i> Reply via Email
                                </a>
                                <?php if($contact->phone): ?>
                                    <a href="tel:<?php echo e($contact->phone); ?>" class="btn btn-outline-success">
                                        <i class="fas fa-phone me-2"></i> Call <?php echo e($contact->phone); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="text-dark">Message</h6>
                        <div class="bg-white border rounded p-3 shadow-sm">
                            <?php echo nl2br(e($contact->message)); ?>

                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between">
                    <a href="<?php echo e(route('admin.contacts.index')); ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-2"></i> Back to Messages
                    </a>
                    <a href="mailto:<?php echo e($contact->email); ?>" class="btn btn-success">
                        <i class="fas fa-reply me-2"></i> Reply to <?php echo e($contact->name); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/contacts/show.blade.php ENDPATH**/ ?>