<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?> - AyzMedFlow</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #1dbf73;
        }

        .sidebar {
            min-height: 100vh;
            background: var(--primary-color);
        }

        .sidebar .nav-link {
            color: rgba(255,255,255);
            padding: 12px 20px;
            margin: 2px 0;
            border-radius: 8px;
            transition: all 0.3s;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
            transform: translateX(5px);
        }

        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        }

        .btn-primary {
            background: linear-gradient(135deg, #1dbf73 0%, #1dbf73 100%);
            border: none;
            border-radius: 8px;
        }

        .navbar-brand {
            font-weight: bold;
            color: var(--primary-color) !important;
        }

        .btn-outline-success {
            border-color: var(--primary-color);
            color: var(--primary-color);
        }

        .btn-outline-success:hover {
            background-color: var(--primary-color);
            color: white !important;
        }

        .btn-success {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .btn-success:hover {
            background-color: #18a961;
            border-color: #18a961;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">

            <!-- Sidebar (visible on large screens) -->
            <div class="col-md-3 col-lg-2 px-0 d-none d-lg-block sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4">
                        <i class="fas fa-user-shield me-2"></i>
                        Quran Ezy
                    </h4>
                    <nav class="nav flex-column">
                        <a class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.home.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.home.index')); ?>">
                            <i class="fas fa-home me-2"></i> Home Page
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.about.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.about.index')); ?>">
                            <i class="fas fa-info-circle me-2"></i> About Us
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.services.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.services.index')); ?>">
                            <i class="fas fa-cogs me-2"></i> Services
                        </a>

                           <a class="nav-link <?php echo e(request()->routeIs('admin.courses.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.courses.index')); ?>">
                            <i class="fas fa-cogs me-2"></i> Courses
                        </a>


                           <a class="nav-link <?php echo e(request()->routeIs('admin.course_category.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.course_category.index')); ?>">
                            <i class="fas fa-cogs me-2"></i> Courses Category
                        </a>
  <a class="nav-link <?php echo e(request()->routeIs('admin.teachers.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.teachers.index')); ?>">
                            <i class="fas fa-cogs me-2"></i> All Teachers
                        </a>


                        <a class="nav-link <?php echo e(request()->routeIs('admin.enrollments.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.enrollments.index')); ?>">
                            <i class="fas fa-cogs me-2"></i> Enrollments
                        </a>


                        <a class="nav-link <?php echo e(request()->routeIs('admin.specialties.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.specialties.index')); ?>">
                            <i class="fas fa-star me-2"></i> Specialties
                        </a>
                          <a class="nav-link " href="<?php echo e(route('admin.posts.index')); ?>">
                            <i class="fas fa-blog me-2"></i> Blogs
                        </a>
                         <a class="nav-link " href="<?php echo e(route('admin.categories.index')); ?>">
                            <i class="fas fa-tag me-2"></i> Blog Categories
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.faqs.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.faqs.index')); ?>">
                            <i class="fas fa-question-circle me-2"></i> FAQs
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.settings.create')); ?>">
                            <i class="fas fa-cog me-2"></i> Settings
                        </a>
                             <a class="nav-link <?php echo e(request()->routeIs('admin.testimonials.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.testimonials.create')); ?>">
                            <i class="fas fa-copy me-2"></i> testimonials
                        </a>
                        
                        <a class="nav-link <?php echo e(request()->routeIs('admin.contacts.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.contacts.index')); ?>">
                            <i class="fas fa-envelope me-2"></i> Contact Forms
                        </a>
                                    <a class="nav-link " href="<?php echo e(route('admin.appointments.index')); ?>">
                            <i class="fas fa-calendar-plus me-2"></i> Appointments
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.admin-users.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.admin-users.index')); ?>">
                            <i class="fas fa-users me-2"></i> Admin Users
                        </a>
                        <hr class="text-white-50">
                        <form action="<?php echo e(route('admin.logout')); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="nav-link border-0 bg-transparent text-start w-100">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </button>
                        </form>
                    </nav>
                </div>
            </div>

            <!-- Offcanvas Sidebar for Small Screens -->
            <div class="offcanvas offcanvas-start d-lg-none sidebar" tabindex="-1" id="sidebarOffcanvas">
                <div class="offcanvas-header border-bottom">
                    <h5 class="text-white">Menu</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
                </div>
                <div class="offcanvas-body p-0">
                    <nav class="nav flex-column p-3">
                        <a class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.home.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.home.index')); ?>">
                            <i class="fas fa-home me-2"></i> Home Page
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.about.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.about.index')); ?>">
                            <i class="fas fa-info-circle me-2"></i> About Us
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.services.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.services.index')); ?>">
                            <i class="fas fa-cogs me-2"></i> Services
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.specialties.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.specialties.index')); ?>">
                            <i class="fas fa-star me-2"></i> Specialties
                        </a>
                            <a class="nav-link " href="<?php echo e(route('admin.posts.index')); ?>">
                            <i class="fas fa-blog me-2"></i> Blogs
                        </a>
                           <a class="nav-link " href="<?php echo e(route('admin.categories.index')); ?>">
                            <i class="fas fa-tag me-2"></i> Blog Categories
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.faqs.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.faqs.index')); ?>">
                            <i class="fas fa-question-circle me-2"></i> FAQs
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.settings.index')); ?>">
                            <i class="fas fa-cog me-2"></i> Settings
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.contacts.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.contacts.index')); ?>">
                            <i class="fas fa-envelope me-2"></i> Contact Forms
                        </a>
                                    <a class="nav-link " href="<?php echo e(route('admin.appointments.index')); ?>">
                            <i class="fas fa-calendar me-2"></i> Appointments
                        </a>
                        <a class="nav-link <?php echo e(request()->routeIs('admin.admin-users.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.admin-users.index')); ?>">
                            <i class="fas fa-users me-2"></i> Admin Users
                        </a>
                        <hr class="text-white-50">
                        <form action="<?php echo e(route('admin.logout')); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="nav-link border-0 bg-transparent text-start w-100">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </button>
                        </form>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 main-content">
                <!-- Top Navigation -->
                <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
                    <div class="container-fluid">
                        <button class="btn btn-success d-lg-none me-3" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarOffcanvas">
                            <i class="fas fa-bars"></i>
                        </button>
<span class="navbar-brand d-none d-md-inline"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></span>

                        <div class="dropdown ms-auto">
                            <button class="btn btn-outline-dark dropdown-toggle d-flex align-items-center" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-user-circle me-2"></i> <?php echo e(Auth::guard('admin')->user()->name); ?>

                            </button>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                           <li>
    <a class="dropdown-item" href="<?php echo e(route('admin.admin-users.index')); ?>">
        <i class="fas fa-user-cog me-2 text-dark"></i>Admin Settings
    </a>
</li>

                                <li><hr class="dropdown-divider"></li>
                                      
                                      <li><a class="dropdown-item <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.settings.index')); ?>">
                            <i class="fas fa-cog me-2"></i> Settings
                        </a>

                                                        <li><hr class="dropdown-divider"></li>

                                <li>
                                    <form action="<?php echo e(route('admin.logout')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button class="dropdown-item text-danger" type="submit">
                                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </div>
                </nav>

                <!-- Page Content -->
                <div class="container-fluid py-4">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>