

<?php $__env->startSection('title', 'Enrollment Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="fw-bold text-dark">
                    <i class="fas fa-eye me-2 text-primary"></i> Enrollment Details
                </h1>
                <a href="<?php echo e(route('admin.enrollments.index')); ?>" class="btn btn-secondary shadow-sm">
                    <i class="fas fa-arrow-left me-2"></i> Back to Enrollments
                </a>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- Left Side: Enrollment Info -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-lg rounded-3">
                <div class="card-header bg-gradient-primary text-dark">
                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i> Enrollment Information</h5>
                </div>
                <div class="card-body bg-light">
                    <div class="row">
                        <!-- Student Information -->
                        <div class="col-md-6 mb-4">
                            <div class="p-3 bg-white rounded-3 shadow-sm">
                                <h5 class="text-primary mb-3"><i class="fas fa-user-graduate me-2"></i> Student Information</h5>
                                <ul class="list-unstyled mb-0">
                                    <li><strong><i class="fas fa-user me-2 text-secondary"></i>Name:</strong> <?php echo e($enrollment->first_name); ?> <?php echo e($enrollment->last_name); ?></li>
                                    <li><strong><i class="fas fa-envelope me-2 text-secondary"></i>Email:</strong> <?php echo e($enrollment->email); ?></li>
                                    <li><strong><i class="fas fa-phone me-2 text-secondary"></i>Phone:</strong> <?php echo e($enrollment->phone); ?></li>
                                    <li><strong><i class="fas fa-graduation-cap me-2 text-secondary"></i>Education:</strong> <?php echo e($enrollment->education_level ?? 'Not specified'); ?></li>
                                    <li><strong><i class="fas fa-briefcase me-2 text-secondary"></i>Experience:</strong> <?php echo e($enrollment->experience_level ?? 'Not specified'); ?></li>
                                </ul>
                            </div>
                        </div>

                        <!-- Course Information -->
                        <div class="col-md-6 mb-4">
                            <div class="p-3 bg-white rounded-3 shadow-sm">
                                <h5 class="text-success mb-3"><i class="fas fa-book-open me-2"></i> Course Information</h5>
                                <ul class="list-unstyled mb-0">
                                    <li><strong><i class="fas fa-book me-2 text-secondary"></i>Course:</strong> <?php echo e($enrollment->course->title); ?></li>
                                    <li><strong><i class="fas fa-layer-group me-2 text-secondary"></i>Level:</strong> <?php echo e(ucfirst($enrollment->course->level)); ?></li>
                                    <li><strong><i class="fas fa-clock me-2 text-secondary"></i>Duration:</strong> <?php echo e($enrollment->course->duration_value); ?> <?php echo e($enrollment->course->duration_type); ?></li>
                                    <li><strong><i class="fas fa-tags me-2 text-secondary"></i>Price Type:</strong> <?php echo e(ucfirst($enrollment->course->price_type)); ?></li>
                                    <li><strong><i class="fas fa-calendar-alt me-2 text-secondary"></i>Schedule:</strong> <?php echo e(ucfirst($enrollment->preferred_schedule)); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Motivation Section -->
                    <?php if($enrollment->motivation): ?>
                    <div class="mt-4 p-3 bg-white rounded-3 shadow-sm">
                        <h5 class="text-warning"><i class="fas fa-lightbulb me-2"></i> Student Motivation</h5>
                        <div class="alert alert-light border mt-2">
                            <p class="mb-0"><?php echo e($enrollment->motivation); ?></p>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Enrollment Details -->
                    <div class="mt-4 p-3 bg-white rounded-3 shadow-sm">
                        <h5 class="text-info mb-3"><i class="fas fa-file-alt me-2"></i> Enrollment Details</h5>
                        <ul class="list-unstyled mb-0">
                            <li><strong><i class="fas fa-hashtag me-2 text-secondary"></i>Code:</strong> <?php echo e($enrollment->enrollment_code); ?></li>
                            <li>
                                <strong><i class="fas fa-flag me-2 text-secondary"></i>Status:</strong>
                                <?php if($enrollment->status == 'pending'): ?>
                                    <span class="badge bg-warning text-dark"><i class="fas fa-hourglass-half me-1"></i> Pending</span>
                                <?php elseif($enrollment->status == 'confirmed'): ?>
                                    <span class="badge bg-success"><i class="fas fa-check-circle me-1"></i> Confirmed</span>
                                <?php elseif($enrollment->status == 'completed'): ?>
                                    <span class="badge bg-info text-dark"><i class="fas fa-flag-checkered me-1"></i> Completed</span>
                                <?php else: ?>
                                    <span class="badge bg-danger"><i class="fas fa-times-circle me-1"></i> Cancelled</span>
                                <?php endif; ?>
                            </li>
                            <li><strong><i class="fas fa-calendar me-2 text-secondary"></i>Enrolled On:</strong> <?php echo e($enrollment->created_at->format('F d, Y \a\t h:i A')); ?></li>
                            <li><strong><i class="fas fa-envelope-open-text me-2 text-secondary"></i>Newsletter:</strong> <?php echo e($enrollment->newsletter_optin ? 'Subscribed' : 'Not Subscribed'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Side: Quick Actions -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-lg rounded-3">
                <div class="card-header bg-gradient-success text-dark">
                    <h5 class="mb-0"><i class="fas fa-bolt me-2"></i> Quick Actions</h5>
                </div>
                <div class="card-body bg-light">
                    <form action="<?php echo e(route('admin.enrollments.update', $enrollment->id)); ?>" method="POST" class="p-3 bg-white rounded-3 shadow-sm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="mb-3">
                            <label class="form-label fw-bold text-dark"><i class="fas fa-sync-alt me-2 text-primary"></i> Update Status</label>
                            <select name="status" class="form-select border-primary shadow-sm" required>
                                <option value="pending" <?php echo e($enrollment->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="confirmed" <?php echo e($enrollment->status == 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                                <option value="completed" <?php echo e($enrollment->status == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                <option value="cancelled" <?php echo e($enrollment->status == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary w-100 shadow-sm">
                            <i class="fas fa-save me-2"></i> Update Status
                        </button>
                    </form>

                    <hr>

                    <div class="d-grid gap-2">
                        <a href="mailto:<?php echo e($enrollment->email); ?>" class="btn btn-outline-primary shadow-sm">
                            <i class="fas fa-envelope me-2"></i> Send Email
                        </a>
                        <a href="tel:<?php echo e($enrollment->phone); ?>" class="btn btn-outline-success shadow-sm">
                            <i class="fas fa-phone me-2"></i> Call Student
                        </a>
                    </div>
                </div>

                <div class="card-footer text-center bg-white border-0">
                    <small class="text-muted"><i class="fas fa-info-circle me-1"></i> Last updated: <?php echo e($enrollment->updated_at->diffForHumans()); ?></small>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\xampp2\htdocs\ayz\resources\views/admin/enrollments/show.blade.php ENDPATH**/ ?>