@extends('admin.layouts.app')

@section('title', 'About Us Management')
@section('page-title', 'About Us Management')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    About Us Content List
                </h5>
                <a href="{{ route('admin.about.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add New Content
                </a>
            </div>
            <div class="card-body">
                @if($aboutContents->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Mission Statement</th>
                                    <th>Status</th>
                                    <th>Image</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($aboutContents as $content)
                                <tr>
                                    <td>{{ $content->id }}</td>
                                    <td>{{ Str::limit($content->title, 30) }}</td>
                                    <td>{{ Str::limit($content->mission_statement, 30) }}</td>
                                    <td>
                                        @if($content->is_active)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-secondary">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($content->image)
                                            <img src="{{ $content->image_url }}" alt="Image" class="img-thumbnail" style="width: 50px; height: 50px; object-fit: cover;">
                                        @else
                                            <span class="text-muted">No Image</span>
                                        @endif
                                    </td>
                                    <td>{{ $content->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.about.show', $content) }}" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.about.edit', $content) }}" class="btn btn-sm btn-outline-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.about.destroy', $content) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this content?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-center">
                        {{ $aboutContents->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-info-circle fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No about content found</h5>
                        <p class="text-muted">Start by adding your first about content.</p>
                        <a href="{{ route('admin.about.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add About Content
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

