@extends('admin.layouts.app')

@section('title', 'View About Content')
@section('page-title', 'View About Content')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-eye me-2"></i>
                    About Content Details
                </h5>
                <div>
                    <a href="{{ route('admin.about.edit', $about) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit me-1"></i>Edit
                    </a>
                    <form action="{{ route('admin.about.destroy', $about) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this content?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm">
                            <i class="fas fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <table class="table table-borderless">
                            <tr>
                                <th width="200">Title:</th>
                                <td>{{ $about->title }}</td>
                            </tr>
                            <tr>
                                <th>Subtitle:</th>
                                <td>{{ $about->subtitle }}</td>
                            </tr>
                            <tr>
                                <th>Mission Statement:</th>
                                <td>{{ $about->mission_statement }}</td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>
                                    @if($about->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Created At:</th>
                                <td>{{ $about->created_at->format('M d, Y h:i A') }}</td>
                            </tr>
                            <tr>
                                <th>Updated At:</th>
                                <td>{{ $about->updated_at->format('M d, Y h:i A') }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-4">
                        @if($about->image)
                            <div class="text-center">
                                <h6>Image</h6>
                                <img src="{{ $about->image_url }}" alt="About Image" class="img-fluid rounded shadow">
                            </div>
                        @else
                            <div class="text-center text-muted">
                                <i class="fas fa-image fa-3x mb-2"></i>
                                <p>No image uploaded</p>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-12">
                        <h6>Description</h6>
                        <div class="p-3 bg-light rounded">
                            {!! nl2br(e($about->description)) !!}
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('admin.about.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                    <a href="{{ route('admin.about.edit', $about) }}" class="btn btn-primary">
                        <i class="fas fa-edit me-2"></i>Edit Content
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

