@extends('admin.layouts.app')

@section('title', 'Admin Users Management')
@section('page-title', 'Admin Users Management')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-users me-2"></i>
                    Admin Users List
                </h5>
                <a href="{{ route('admin.admin-users.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add New Admin
                </a>
            </div>
            <div class="card-body">
                @if($adminUsers->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Created At</th>
                                    <th>Last Updated</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($adminUsers as $user)
                                <tr>
                                    <td>{{ $user->id }}</td>
                                    <td>
                                        {{ $user->name }}
                                        @if($user->id === auth('admin')->id())
                                            <span class="badge bg-info ms-1">You</span>
                                        @endif
                                    </td>
                                    <td>{{ $user->email }}</td>
<td>
    {{ $user->created_at ? $user->created_at->format('M d, Y') : 'N/A' }}
</td>                                    <td>{{ $user->updated_at->format('M d, Y') }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.admin-users.show', $user) }}" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.admin-users.edit', $user) }}" class="btn btn-sm btn-outline-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if($user->id !== auth('admin')->id() && $adminUsers->total() > 1)
                                                <form action="{{ route('admin.admin-users.destroy', $user) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this admin user?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-center">
                        {{ $adminUsers->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-users fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No admin users found</h5>
                        <p class="text-muted">Start by adding your first admin user.</p>
                        <a href="{{ route('admin.admin-users.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add Admin User
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

