@extends('admin.layouts.app')

@section('title', 'View Admin User')
@section('page-title', 'View Admin User')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-user me-2"></i>
                    Admin User Details
                </h5>
                <div>
                    <a href="{{ route('admin.admin-users.edit', $adminUser) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit me-1"></i>Edit
                    </a>
                    @if($adminUser->id !== auth('admin')->id() && \App\Models\AdminUser::count() > 1)
                        <form action="{{ route('admin.admin-users.destroy', $adminUser) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this admin user?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm">
                                <i class="fas fa-trash me-1"></i>Delete
                            </button>
                        </form>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <table class="table table-borderless">
                            <tr>
                                <th width="200">ID:</th>
                                <td>{{ $adminUser->id }}</td>
                            </tr>
                            <tr>
                                <th>Name:</th>
                                <td>{{ $adminUser->name }}</td>
                            </tr>
                            <tr>
                                <th>Email:</th>
                                <td>{{ $adminUser->email }}</td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>
                                    @if($adminUser->id === auth('admin')->id())
                                        <span class="badge bg-info">Current User</span>
                                    @else
                                        <span class="badge bg-success">Active</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Created At:</th>
                                <td>{{ $adminUser->created_at->format('M d, Y h:i A') }}</td>
                            </tr>
                            <tr>
                                <th>Updated At:</th>
                                <td>{{ $adminUser->updated_at->format('M d, Y h:i A') }}</td>
                            </tr>
                            <tr>
                                <th>Last Login:</th>
                                <td>
                                    @if($adminUser->id === auth('admin')->id())
                                        <span class="text-success">Currently logged in</span>
                                    @else
                                        <span class="text-muted">Not available</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center">
                            <div class="mb-3">
                                <i class="fas fa-user-shield fa-5x text-primary"></i>
                            </div>
                            <h6>Admin User</h6>
                            <p class="text-muted">Full access to admin panel</p>
                            
                            @if($adminUser->id === auth('admin')->id())
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    This is your current account
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('admin.admin-users.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                    <a href="{{ route('admin.admin-users.edit', $adminUser) }}" class="btn btn-primary">
                        <i class="fas fa-edit me-2"></i>Edit User
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

