@extends('admin.layouts.app')

@section('title', 'View Contact Message')
@section('page-title', 'View Contact Message')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-envelope me-2"></i>
                    Contact Message Details
                    @if(!$contact->is_read)
                        <span class="badge bg-primary ms-2">New</span>
                    @endif
                </h5>
                <form action="{{ route('admin.contacts.destroy', $contact) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this message?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm">
                        <i class="fas fa-trash me-1"></i>Delete
                    </button>
                </form>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th width="150">Name:</th>
                                <td>{{ $contact->name }}</td>
                            </tr>
                            <tr>
                                <th>Email:</th>
                                <td><a href="mailto:{{ $contact->email }}">{{ $contact->email }}</a></td>
                            </tr>
                            <tr>
                                <th>Phone:</th>
                                <td>{{ $contact->phone ?: 'Not provided' }}</td>
                            </tr>
                            <tr>
                                <th>Subject:</th>
                                <td>{{ $contact->subject ?: 'No subject' }}</td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>
                                    @if($contact->is_read)
                                        <span class="badge bg-success">Read</span>
                                    @else
                                        <span class="badge bg-warning">Unread</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Received At:</th>
                                <td>{{ $contact->created_at->format('M d, Y h:i A') }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <div class="text-center">
                            <h6>Quick Actions</h6>
                            <div class="d-grid gap-2">
                                <a href="mailto:{{ $contact->email }}" class="btn btn-primary">
                                    <i class="fas fa-reply me-2"></i>Reply via Email
                                </a>
                                @if($contact->phone)
                                    <a href="tel:{{ $contact->phone }}" class="btn btn-success">
                                        <i class="fas fa-phone me-2"></i>Call {{ $contact->phone }}
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-12">
                        <h6>Message</h6>
                        <div class="p-3 bg-light rounded">
                            {!! nl2br(e($contact->message)) !!}
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('admin.contacts.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to Messages
                    </a>
                    <a href="mailto:{{ $contact->email }}" class="btn btn-primary">
                        <i class="fas fa-reply me-2"></i>Reply to {{ $contact->name }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

