@extends('admin.layouts.app')

@section('title', 'Edit FAQ')
@section('page-title', 'Edit FAQ')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-edit me-2"></i>
                    Edit FAQ
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.faqs.update', $faq) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="question" class="form-label">Question <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control @error('question') is-invalid @enderror" 
                               id="question" 
                               name="question" 
                               value="{{ old('question', $faq->question) }}" 
                               placeholder="Enter the frequently asked question"
                               required>
                        @error('question')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="answer" class="form-label">Answer <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('answer') is-invalid @enderror" 
                                  id="answer" 
                                  name="answer" 
                                  rows="6" 
                                  placeholder="Enter the detailed answer to this question"
                                  required>{{ old('answer', $faq->answer) }}</textarea>
                        @error('answer')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Provide a clear and comprehensive answer to help users understand.</div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" 
                                       class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" 
                                       name="sort_order" 
                                       value="{{ old('sort_order', $faq->sort_order) }}" 
                                       min="0"
                                       placeholder="0">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Lower numbers appear first. Leave empty for automatic ordering.</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="is_active" class="form-label">Status</label>
                                <select class="form-select @error('is_active') is-invalid @enderror" 
                                        id="is_active" 
                                        name="is_active">
                                    <option value="1" {{ old('is_active', $faq->is_active) == '1' ? 'selected' : '' }}>Active</option>
                                    <option value="0" {{ old('is_active', $faq->is_active) == '0' ? 'selected' : '' }}>Inactive</option>
                                </select>
                                @error('is_active')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Only active FAQs will be displayed on the website.</div>
                            </div>
                        </div>
                    </div>

                    <div class="card bg-light mb-3">
                        <div class="card-header">
                            <h6 class="mb-0">
                                <i class="fas fa-eye me-2"></i>Preview
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="accordion" id="faqPreview">
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePreview">
                                            <span id="preview-question">{{ $faq->question }}</span>
                                        </button>
                                    </h2>
                                    <div id="collapsePreview" class="accordion-collapse collapse" data-bs-parent="#faqPreview">
                                        <div class="accordion-body">
                                            <span id="preview-answer">{{ $faq->answer }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.faqs.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Back to List
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update FAQ
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// Live preview update
document.getElementById('question').addEventListener('input', function() {
    document.getElementById('preview-question').textContent = this.value || 'Your question will appear here...';
});

document.getElementById('answer').addEventListener('input', function() {
    document.getElementById('preview-answer').textContent = this.value || 'Your answer will appear here...';
});
</script>
@endsection

