@extends('admin.layouts.app')

@section('title', 'View FAQ')
@section('page-title', 'View FAQ')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-question-circle me-2"></i>
                    FAQ Details
                </h5>
                <div>
                    <a href="{{ route('admin.faqs.edit', $faq) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit me-1"></i>Edit
                    </a>
                    <form action="{{ route('admin.faqs.destroy', $faq) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this FAQ?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm">
                            <i class="fas fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <table class="table table-borderless">
                            <tr>
                                <th width="200">ID:</th>
                                <td>{{ $faq->id }}</td>
                            </tr>
                            <tr>
                                <th>Question:</th>
                                <td>
                                    <div class="p-3 bg-light rounded border-start border-primary border-4">
                                        <h6 class="mb-0">{{ $faq->question }}</h6>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <th>Answer:</th>
                                <td>
                                    <div class="p-3 bg-light rounded">
                                        {!! nl2br(e($faq->answer)) !!}
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <th>Sort Order:</th>
                                <td>
                                    <span class="badge bg-info">{{ $faq->sort_order }}</span>
                                </td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>
                                    @if($faq->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Created At:</th>
                                <td>{{ $faq->created_at->format('M d, Y h:i A') }}</td>
                            </tr>
                            <tr>
                                <th>Updated At:</th>
                                <td>{{ $faq->updated_at->format('M d, Y h:i A') }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center">
                            <div class="mb-3">
                                <i class="fas fa-question-circle fa-5x text-primary"></i>
                            </div>
                            <h6>FAQ Item</h6>
                            <p class="text-muted">Frequently Asked Question</p>
                            
                            <div class="mt-3">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">Preview</h6>
                                        <div class="accordion" id="faqPreview">
                                            <div class="accordion-item">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePreview">
                                                        {{ Str::limit($faq->question, 50) }}
                                                    </button>
                                                </h2>
                                                <div id="collapsePreview" class="accordion-collapse collapse" data-bs-parent="#faqPreview">
                                                    <div class="accordion-body">
                                                        {{ Str::limit($faq->answer, 100) }}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('admin.faqs.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                    <a href="{{ route('admin.faqs.edit', $faq) }}" class="btn btn-primary">
                        <i class="fas fa-edit me-2"></i>Edit FAQ
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

