@extends('admin.layouts.app')

@section('title', 'Edit Service')
@section('page-title', 'Edit Service')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-edit me-2"></i>
                    Edit Service
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.services.update', $service) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control @error('title') is-invalid @enderror" 
                               id="title" 
                               name="title" 
                               value="{{ old('title', $service->title) }}" 
                               placeholder="Enter service title"
                               required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" 
                                  name="description" 
                                  rows="6" 
                                  placeholder="Enter detailed description of this service"
                                  required>{{ old('description', $service->description) }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Describe the service, its benefits, and what makes it unique.</div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="image1" class="form-label">Primary Image</label>
                                @if($service->image1)
                                    <div class="mb-2">
                                        <img src="{{ Storage::url($service->image1) }}" 
                                             alt="{{ $service->title }}" 
                                             class="img-thumbnail" 
                                             style="max-width: 200px; max-height: 150px;">
                                        <div class="form-text">Current primary image</div>
                                    </div>
                                @endif
                                <input type="file" 
                                       class="form-control @error('image1') is-invalid @enderror" 
                                       id="image1" 
                                       name="image1" 
                                       accept="image/*">
                                @error('image1')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">
                                    Supported formats: JPG, PNG, GIF. Max size: 2MB. Recommended size: 600x400px
                                    @if($service->image1)
                                        <br>Leave empty to keep current image
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="image2" class="form-label">Secondary Image</label>
                                @if($service->image2)
                                    <div class="mb-2">
                                        <img src="{{ Storage::url($service->image2) }}" 
                                             alt="{{ $service->title }}" 
                                             class="img-thumbnail" 
                                             style="max-width: 200px; max-height: 150px;">
                                        <div class="form-text">Current secondary image</div>
                                    </div>
                                @endif
                                <input type="file" 
                                       class="form-control @error('image2') is-invalid @enderror" 
                                       id="image2" 
                                       name="image2" 
                                       accept="image/*">
                                @error('image2')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">
                                    Supported formats: JPG, PNG, GIF. Max size: 2MB. Recommended size: 600x400px
                                    @if($service->image2)
                                        <br>Leave empty to keep current image
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="is_active" class="form-label">Status</label>
                        <select class="form-select @error('is_active') is-invalid @enderror" 
                                id="is_active" 
                                name="is_active">
                            <option value="1" {{ old('is_active', $service->is_active) == '1' ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ old('is_active', $service->is_active) == '0' ? 'selected' : '' }}>Inactive</option>
                        </select>
                        @error('is_active')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Only active services will be displayed on the website.</div>
                    </div>

                    <div class="card bg-light mb-3">
                        <div class="card-header">
                            <h6 class="mb-0">
                                <i class="fas fa-eye me-2"></i>Preview
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    @if($service->image1)
                                        <img src="{{ Storage::url($service->image1) }}" 
                                             alt="{{ $service->title }}" 
                                             class="img-fluid rounded mb-3"
                                             id="preview-image1">
                                    @else
                                        <div class="bg-secondary rounded d-flex align-items-center justify-content-center mb-3" style="height: 200px;" id="preview-image1-placeholder">
                                            <i class="fas fa-image fa-3x text-white"></i>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    @if($service->image2)
                                        <img src="{{ Storage::url($service->image2) }}" 
                                             alt="{{ $service->title }}" 
                                             class="img-fluid rounded mb-3"
                                             id="preview-image2">
                                    @else
                                        <div class="bg-secondary rounded d-flex align-items-center justify-content-center mb-3" style="height: 200px;" id="preview-image2-placeholder">
                                            <i class="fas fa-image fa-3x text-white"></i>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="text-center">
                                <h5 id="preview-title">{{ $service->title }}</h5>
                                <p class="text-muted" id="preview-description">{{ Str::limit($service->description, 200) }}</p>
                                <button class="btn btn-primary" disabled>Learn More</button>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.services.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Back to List
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Service
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// Live preview update
document.getElementById('title').addEventListener('input', function() {
    document.getElementById('preview-title').textContent = this.value || 'Service Title';
});

document.getElementById('description').addEventListener('input', function() {
    const text = this.value || 'Service description will appear here...';
    document.getElementById('preview-description').textContent = text.length > 200 ? text.substring(0, 200) + '...' : text;
});

// Image preview for image1
document.getElementById('image1').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const previewImage = document.getElementById('preview-image1');
            const placeholder = document.getElementById('preview-image1-placeholder');
            
            if (previewImage) {
                previewImage.src = e.target.result;
            } else if (placeholder) {
                placeholder.outerHTML = '<img src="' + e.target.result + '" alt="Preview" class="img-fluid rounded mb-3" id="preview-image1">';
            }
        };
        reader.readAsDataURL(file);
    }
});

// Image preview for image2
document.getElementById('image2').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const previewImage = document.getElementById('preview-image2');
            const placeholder = document.getElementById('preview-image2-placeholder');
            
            if (previewImage) {
                previewImage.src = e.target.result;
            } else if (placeholder) {
                placeholder.outerHTML = '<img src="' + e.target.result + '" alt="Preview" class="img-fluid rounded mb-3" id="preview-image2">';
            }
        };
        reader.readAsDataURL(file);
    }
});
</script>
@endsection

