@extends('admin.layouts.app')

@section('title', 'Add Setting')
@section('page-title', 'Add Setting')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-plus me-2"></i>
                    Add New Setting
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.settings.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="key" class="form-label">Setting Key <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('key') is-invalid @enderror" 
                                       id="key" 
                                       name="key" 
                                       value="{{ old('key') }}" 
                                       placeholder="e.g., site_name, contact_email"
                                       required>
                                @error('key')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Use lowercase letters, numbers, and underscores only</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="type" class="form-label">Setting Type <span class="text-danger">*</span></label>
                                <select class="form-select @error('type') is-invalid @enderror" 
                                        id="type" 
                                        name="type" 
                                        required>
                                    <option value="">Select Type</option>
                                    <option value="text" {{ old('type') == 'text' ? 'selected' : '' }}>Text</option>
                                    <option value="textarea" {{ old('type') == 'textarea' ? 'selected' : '' }}>Textarea</option>
                                    <option value="image" {{ old('type') == 'image' ? 'selected' : '' }}>Image</option>
                                    <option value="url" {{ old('type') == 'url' ? 'selected' : '' }}>URL</option>
                                    <option value="email" {{ old('type') == 'email' ? 'selected' : '' }}>Email</option>
                                    <option value="phone" {{ old('type') == 'phone' ? 'selected' : '' }}>Phone</option>
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="label" class="form-label">Display Label <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control @error('label') is-invalid @enderror" 
                               id="label" 
                               name="label" 
                               value="{{ old('label') }}" 
                               placeholder="e.g., Site Name, Contact Email"
                               required>
                        @error('label')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3" id="value-field">
                        <label for="value" class="form-label">Value</label>
                        <input type="text" 
                               class="form-control @error('value') is-invalid @enderror" 
                               id="value" 
                               name="value" 
                               value="{{ old('value') }}">
                        @error('value')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3" id="image-field" style="display: none;">
                        <label for="image" class="form-label">Image File</label>
                        <input type="file" 
                               class="form-control @error('image') is-invalid @enderror" 
                               id="image" 
                               name="image" 
                               accept="image/*">
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Supported formats: JPG, PNG, GIF. Max size: 2MB</div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" 
                                  name="description" 
                                  rows="3" 
                                  placeholder="Brief description of this setting">{{ old('description') }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.settings.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Back to List
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Create Setting
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const valueField = document.getElementById('value-field');
    const imageField = document.getElementById('image-field');
    const valueInput = document.getElementById('value');
    
    if (type === 'image') {
        valueField.style.display = 'none';
        imageField.style.display = 'block';
        valueInput.required = false;
    } else {
        valueField.style.display = 'block';
        imageField.style.display = 'none';
        valueInput.required = false;
        
        if (type === 'textarea') {
            valueInput.outerHTML = '<textarea class="form-control" id="value" name="value" rows="4">' + valueInput.value + '</textarea>';
        } else if (valueInput.tagName === 'TEXTAREA') {
            const newInput = document.createElement('input');
            newInput.type = type === 'email' ? 'email' : type === 'url' ? 'url' : 'text';
            newInput.className = 'form-control';
            newInput.id = 'value';
            newInput.name = 'value';
            newInput.value = valueInput.value;
            valueInput.parentNode.replaceChild(newInput, valueInput);
        } else {
            valueInput.type = type === 'email' ? 'email' : type === 'url' ? 'url' : 'text';
        }
    }
});
</script>
@endsection

