@extends('admin.layouts.app')

@section('title', 'Edit Setting')
@section('page-title', 'Edit Setting')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-edit me-2"></i>
                    Edit Setting
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.settings.update', $setting) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="key" class="form-label">Setting Key <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('key') is-invalid @enderror" 
                                       id="key" 
                                       name="key" 
                                       value="{{ old('key', $setting->key) }}" 
                                       required>
                                @error('key')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Use lowercase letters, numbers, and underscores only</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="type" class="form-label">Setting Type <span class="text-danger">*</span></label>
                                <select class="form-select @error('type') is-invalid @enderror" 
                                        id="type" 
                                        name="type" 
                                        required>
                                    <option value="">Select Type</option>
                                    <option value="text" {{ old('type', $setting->type) == 'text' ? 'selected' : '' }}>Text</option>
                                    <option value="textarea" {{ old('type', $setting->type) == 'textarea' ? 'selected' : '' }}>Textarea</option>
                                    <option value="image" {{ old('type', $setting->type) == 'image' ? 'selected' : '' }}>Image</option>
                                    <option value="url" {{ old('type', $setting->type) == 'url' ? 'selected' : '' }}>URL</option>
                                    <option value="email" {{ old('type', $setting->type) == 'email' ? 'selected' : '' }}>Email</option>
                                    <option value="phone" {{ old('type', $setting->type) == 'phone' ? 'selected' : '' }}>Phone</option>
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="label" class="form-label">Display Label <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control @error('label') is-invalid @enderror" 
                               id="label" 
                               name="label" 
                               value="{{ old('label', $setting->label) }}" 
                               required>
                        @error('label')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3" id="value-field">
                        <label for="value" class="form-label">Value</label>
                        @if($setting->type === 'textarea')
                            <textarea class="form-control @error('value') is-invalid @enderror" 
                                      id="value" 
                                      name="value" 
                                      rows="4">{{ old('value', $setting->value) }}</textarea>
                        @else
                            <input type="{{ $setting->type === 'email' ? 'email' : ($setting->type === 'url' ? 'url' : 'text') }}" 
                                   class="form-control @error('value') is-invalid @enderror" 
                                   id="value" 
                                   name="value" 
                                   value="{{ old('value', $setting->value) }}">
                        @endif
                        @error('value')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3" id="image-field" style="{{ $setting->type === 'image' ? 'display: block;' : 'display: none;' }}">
                        <label for="image" class="form-label">Image File</label>
                        @if($setting->type === 'image' && $setting->value)
                            <div class="mb-2">
                                <img src="{{ Storage::url($setting->value) }}" 
                                     alt="{{ $setting->label }}" 
                                     class="img-thumbnail" 
                                     style="max-width: 200px; max-height: 150px;">
                                <div class="form-text">Current image</div>
                            </div>
                        @endif
                        <input type="file" 
                               class="form-control @error('image') is-invalid @enderror" 
                               id="image" 
                               name="image" 
                               accept="image/*">
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">
                            Supported formats: JPG, PNG, GIF. Max size: 2MB
                            @if($setting->type === 'image' && $setting->value)
                                <br>Leave empty to keep current image
                            @endif
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" 
                                  name="description" 
                                  rows="3" 
                                  placeholder="Brief description of this setting">{{ old('description', $setting->description) }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.settings.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Back to List
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Setting
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const valueField = document.getElementById('value-field');
    const imageField = document.getElementById('image-field');
    const valueInput = document.getElementById('value');
    
    if (type === 'image') {
        valueField.style.display = 'none';
        imageField.style.display = 'block';
        valueInput.required = false;
    } else {
        valueField.style.display = 'block';
        imageField.style.display = 'none';
        valueInput.required = false;
        
        if (type === 'textarea') {
            if (valueInput.tagName !== 'TEXTAREA') {
                const newTextarea = document.createElement('textarea');
                newTextarea.className = 'form-control';
                newTextarea.id = 'value';
                newTextarea.name = 'value';
                newTextarea.rows = 4;
                newTextarea.value = valueInput.value;
                valueInput.parentNode.replaceChild(newTextarea, valueInput);
            }
        } else if (valueInput.tagName === 'TEXTAREA') {
            const newInput = document.createElement('input');
            newInput.type = type === 'email' ? 'email' : type === 'url' ? 'url' : 'text';
            newInput.className = 'form-control';
            newInput.id = 'value';
            newInput.name = 'value';
            newInput.value = valueInput.value;
            valueInput.parentNode.replaceChild(newInput, valueInput);
        } else {
            valueInput.type = type === 'email' ? 'email' : type === 'url' ? 'url' : 'text';
        }
    }
});
</script>
@endsection

