@extends('admin.layouts.app')

@section('title', 'Site Settings')
@section('page-title', 'Site Settings')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-cog me-2"></i>
                    Site Settings
                </h5>
                @if($setting->id)
                    <a href="{{ route('admin.settings.edit', $setting) }}" class="btn btn-primary">
                        <i class="fas fa-edit me-2"></i>Edit Settings
                    </a>
                @else
                    <a href="{{ route('admin.settings.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Create Settings
                    </a>
                @endif
            </div>
            <div class="card-body">
                @if($setting->id)
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-primary">Basic Information</h6>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="150">Site Name:</th>
                                    <td>{{ $setting->site_name ?: 'Not set' }}</td>
                                </tr>
                                <tr>
                                    <th>Email:</th>
                                    <td>{{ $setting->site_email ?: 'Not set' }}</td>
                                </tr>
                                <tr>
                                    <th>Phone:</th>
                                    <td>{{ $setting->site_phone ?: 'Not set' }}</td>
                                </tr>
                                <tr>
                                    <th>Address:</th>
                                    <td>{{ $setting->site_address ?: 'Not set' }}</td>
                                </tr>
                            </table>

                            <h6 class="text-primary mt-4">Social Media</h6>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="150">Facebook:</th>
                                    <td>{{ $setting->facebook_url ?: 'Not set' }}</td>
                                </tr>
                                <tr>
                                    <th>Instagram:</th>
                                    <td>{{ $setting->instagram_url ?: 'Not set' }}</td>
                                </tr>
                                <tr>
                                    <th>TikTok:</th>
                                    <td>{{ $setting->tiktok_url ?: 'Not set' }}</td>
                                </tr>
                                <tr>
                                    <th>LinkedIn:</th>
                                    <td>{{ $setting->linkedin_url ?: 'Not set' }}</td>
                                </tr>
                                <tr>
                                    <th>YouTube:</th>
                                    <td>{{ $setting->youtube_url ?: 'Not set' }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <h6 class="text-primary">Images</h6>
                            <div class="row">
                                <div class="col-6">
                                    <strong>Logo:</strong><br>
                                    @if($setting->logo)
                                        <img src="{{ $setting->logo_url }}" alt="Logo" class="img-thumbnail mt-2" style="max-width: 150px;">
                                    @else
                                        <span class="text-muted">Not uploaded</span>
                                    @endif
                                </div>
                                <div class="col-6">
                                    <strong>Favicon:</strong><br>
                                    @if($setting->favicon)
                                        <img src="{{ $setting->favicon_url }}" alt="Favicon" class="img-thumbnail mt-2" style="max-width: 50px;">
                                    @else
                                        <span class="text-muted">Not uploaded</span>
                                    @endif
                                </div>
                            </div>

                            <h6 class="text-primary mt-4">SEO</h6>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="150">Meta Description:</th>
                                    <td>{{ Str::limit($setting->meta_description, 50) ?: 'Not set' }}</td>
                                </tr>
                                <tr>
                                    <th>Meta Keywords:</th>
                                    <td>{{ Str::limit($setting->meta_keywords, 50) ?: 'Not set' }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-12">
                            <h6 class="text-primary">Content Sections</h6>
                            <div class="row">
                                <div class="col-md-4">
                                    <strong>Header Content:</strong>
                                    <div class="p-2 bg-light rounded mt-1">
                                        {{ Str::limit($setting->header_content, 100) ?: 'Not set' }}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <strong>Hero Content:</strong>
                                    <div class="p-2 bg-light rounded mt-1">
                                        {{ Str::limit($setting->hero_content, 100) ?: 'Not set' }}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <strong>Footer Content:</strong>
                                    <div class="p-2 bg-light rounded mt-1">
                                        {{ Str::limit($setting->footer_content, 100) ?: 'Not set' }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($setting->map_embed_code)
                        <div class="row mt-4">
                            <div class="col-12">
                                <h6 class="text-primary">Map Location</h6>
                                <div class="embed-responsive embed-responsive-16by9">
                                    {!! $setting->map_embed_code !!}
                                </div>
                            </div>
                        </div>
                    @endif
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-cog fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No settings configured</h5>
                        <p class="text-muted">Start by creating your site settings.</p>
                        <a href="{{ route('admin.settings.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Create Settings
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

